/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCreateAccountStatusRequest extends OrganizationsRequest implements
        ToCopyableBuilder<DescribeCreateAccountStatusRequest.Builder, DescribeCreateAccountStatusRequest> {
    private static final SdkField<String> CREATE_ACCOUNT_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateAccountRequestId").getter(getter(DescribeCreateAccountStatusRequest::createAccountRequestId))
            .setter(setter(Builder::createAccountRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAccountRequestId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CREATE_ACCOUNT_REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String createAccountRequestId;

    private DescribeCreateAccountStatusRequest(BuilderImpl builder) {
        super(builder);
        this.createAccountRequestId = builder.createAccountRequestId;
    }

    /**
     * <p>
     * Specifies the <code>Id</code> value that uniquely identifies the <code>CreateAccount</code> request. You can get
     * the value from the <code>CreateAccountStatus.Id</code> response in an earlier <a>CreateAccount</a> request, or
     * from the <a>ListCreateAccountStatus</a> operation.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string requires
     * "car-" followed by from 8 to 32 lowercase letters or digits.
     * </p>
     * 
     * @return Specifies the <code>Id</code> value that uniquely identifies the <code>CreateAccount</code> request. You
     *         can get the value from the <code>CreateAccountStatus.Id</code> response in an earlier
     *         <a>CreateAccount</a> request, or from the <a>ListCreateAccountStatus</a> operation.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string
     *         requires "car-" followed by from 8 to 32 lowercase letters or digits.
     */
    public final String createAccountRequestId() {
        return createAccountRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createAccountRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCreateAccountStatusRequest)) {
            return false;
        }
        DescribeCreateAccountStatusRequest other = (DescribeCreateAccountStatusRequest) obj;
        return Objects.equals(createAccountRequestId(), other.createAccountRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCreateAccountStatusRequest").add("CreateAccountRequestId", createAccountRequestId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateAccountRequestId":
            return Optional.ofNullable(clazz.cast(createAccountRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreateAccountRequestId", CREATE_ACCOUNT_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCreateAccountStatusRequest, T> g) {
        return obj -> g.apply((DescribeCreateAccountStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCreateAccountStatusRequest> {
        /**
         * <p>
         * Specifies the <code>Id</code> value that uniquely identifies the <code>CreateAccount</code> request. You can
         * get the value from the <code>CreateAccountStatus.Id</code> response in an earlier <a>CreateAccount</a>
         * request, or from the <a>ListCreateAccountStatus</a> operation.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string
         * requires "car-" followed by from 8 to 32 lowercase letters or digits.
         * </p>
         * 
         * @param createAccountRequestId
         *        Specifies the <code>Id</code> value that uniquely identifies the <code>CreateAccount</code> request.
         *        You can get the value from the <code>CreateAccountStatus.Id</code> response in an earlier
         *        <a>CreateAccount</a> request, or from the <a>ListCreateAccountStatus</a> operation.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string
         *        requires "car-" followed by from 8 to 32 lowercase letters or digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createAccountRequestId(String createAccountRequestId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String createAccountRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCreateAccountStatusRequest model) {
            super(model);
            createAccountRequestId(model.createAccountRequestId);
        }

        public final String getCreateAccountRequestId() {
            return createAccountRequestId;
        }

        public final void setCreateAccountRequestId(String createAccountRequestId) {
            this.createAccountRequestId = createAccountRequestId;
        }

        @Override
        public final Builder createAccountRequestId(String createAccountRequestId) {
            this.createAccountRequestId = createAccountRequestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCreateAccountStatusRequest build() {
            return new DescribeCreateAccountStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
