/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationalUnitResponse extends OrganizationsResponse implements
        ToCopyableBuilder<DescribeOrganizationalUnitResponse.Builder, DescribeOrganizationalUnitResponse> {
    private static final SdkField<OrganizationalUnit> ORGANIZATIONAL_UNIT_FIELD = SdkField
            .<OrganizationalUnit> builder(MarshallingType.SDK_POJO).memberName("OrganizationalUnit")
            .getter(getter(DescribeOrganizationalUnitResponse::organizationalUnit)).setter(setter(Builder::organizationalUnit))
            .constructor(OrganizationalUnit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATIONAL_UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final OrganizationalUnit organizationalUnit;

    private DescribeOrganizationalUnitResponse(BuilderImpl builder) {
        super(builder);
        this.organizationalUnit = builder.organizationalUnit;
    }

    /**
     * <p>
     * A structure that contains details about the specified OU.
     * </p>
     * 
     * @return A structure that contains details about the specified OU.
     */
    public final OrganizationalUnit organizationalUnit() {
        return organizationalUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationalUnitResponse)) {
            return false;
        }
        DescribeOrganizationalUnitResponse other = (DescribeOrganizationalUnitResponse) obj;
        return Objects.equals(organizationalUnit(), other.organizationalUnit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrganizationalUnitResponse").add("OrganizationalUnit", organizationalUnit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationalUnit":
            return Optional.ofNullable(clazz.cast(organizationalUnit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationalUnit", ORGANIZATIONAL_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationalUnitResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationalUnitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationalUnitResponse> {
        /**
         * <p>
         * A structure that contains details about the specified OU.
         * </p>
         * 
         * @param organizationalUnit
         *        A structure that contains details about the specified OU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnit(OrganizationalUnit organizationalUnit);

        /**
         * <p>
         * A structure that contains details about the specified OU.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationalUnit.Builder} avoiding the
         * need to create one manually via {@link OrganizationalUnit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationalUnit.Builder#build()} is called immediately and its
         * result is passed to {@link #organizationalUnit(OrganizationalUnit)}.
         * 
         * @param organizationalUnit
         *        a consumer that will call methods on {@link OrganizationalUnit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationalUnit(OrganizationalUnit)
         */
        default Builder organizationalUnit(Consumer<OrganizationalUnit.Builder> organizationalUnit) {
            return organizationalUnit(OrganizationalUnit.builder().applyMutation(organizationalUnit).build());
        }
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private OrganizationalUnit organizationalUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationalUnitResponse model) {
            super(model);
            organizationalUnit(model.organizationalUnit);
        }

        public final OrganizationalUnit.Builder getOrganizationalUnit() {
            return organizationalUnit != null ? organizationalUnit.toBuilder() : null;
        }

        public final void setOrganizationalUnit(OrganizationalUnit.BuilderImpl organizationalUnit) {
            this.organizationalUnit = organizationalUnit != null ? organizationalUnit.build() : null;
        }

        @Override
        public final Builder organizationalUnit(OrganizationalUnit organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        @Override
        public DescribeOrganizationalUnitResponse build() {
            return new DescribeOrganizationalUnitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
