/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.pipes.PipesClient;
import software.amazon.awssdk.services.pipes.PipesServiceClientConfiguration;
import software.amazon.awssdk.services.pipes.internal.PipesServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.pipes.model.ConflictException;
import software.amazon.awssdk.services.pipes.model.CreatePipeRequest;
import software.amazon.awssdk.services.pipes.model.CreatePipeResponse;
import software.amazon.awssdk.services.pipes.model.DeletePipeRequest;
import software.amazon.awssdk.services.pipes.model.DeletePipeResponse;
import software.amazon.awssdk.services.pipes.model.DescribePipeRequest;
import software.amazon.awssdk.services.pipes.model.DescribePipeResponse;
import software.amazon.awssdk.services.pipes.model.InternalException;
import software.amazon.awssdk.services.pipes.model.ListPipesRequest;
import software.amazon.awssdk.services.pipes.model.ListPipesResponse;
import software.amazon.awssdk.services.pipes.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pipes.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pipes.model.NotFoundException;
import software.amazon.awssdk.services.pipes.model.PipesException;
import software.amazon.awssdk.services.pipes.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.pipes.model.StartPipeRequest;
import software.amazon.awssdk.services.pipes.model.StartPipeResponse;
import software.amazon.awssdk.services.pipes.model.StopPipeRequest;
import software.amazon.awssdk.services.pipes.model.StopPipeResponse;
import software.amazon.awssdk.services.pipes.model.TagResourceRequest;
import software.amazon.awssdk.services.pipes.model.TagResourceResponse;
import software.amazon.awssdk.services.pipes.model.ThrottlingException;
import software.amazon.awssdk.services.pipes.model.UntagResourceRequest;
import software.amazon.awssdk.services.pipes.model.UntagResourceResponse;
import software.amazon.awssdk.services.pipes.model.UpdatePipeRequest;
import software.amazon.awssdk.services.pipes.model.UpdatePipeResponse;
import software.amazon.awssdk.services.pipes.model.ValidationException;
import software.amazon.awssdk.services.pipes.transform.CreatePipeRequestMarshaller;
import software.amazon.awssdk.services.pipes.transform.DeletePipeRequestMarshaller;
import software.amazon.awssdk.services.pipes.transform.DescribePipeRequestMarshaller;
import software.amazon.awssdk.services.pipes.transform.ListPipesRequestMarshaller;
import software.amazon.awssdk.services.pipes.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pipes.transform.StartPipeRequestMarshaller;
import software.amazon.awssdk.services.pipes.transform.StopPipeRequestMarshaller;
import software.amazon.awssdk.services.pipes.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pipes.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pipes.transform.UpdatePipeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultPipesClient
implements PipesClient {
    private static final Logger log = Logger.loggerFor(DefaultPipesClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPipesClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipeResponse createPipe(CreatePipeRequest createPipeRequest) throws InternalException, ValidationException, ThrottlingException, NotFoundException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, PipesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPipeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPipesClient.resolveMetricPublishers(clientConfiguration, createPipeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pipes");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePipe");
            CreatePipeResponse createPipeResponse = (CreatePipeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipe").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPipeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePipeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPipeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPipesClient.lambda$createPipe$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePipeResponse deletePipe(DeletePipeRequest deletePipeRequest) throws InternalException, ValidationException, ThrottlingException, NotFoundException, ConflictException, AwsServiceException, SdkClientException, PipesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePipeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPipesClient.resolveMetricPublishers(clientConfiguration, deletePipeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pipes");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePipe");
            DeletePipeResponse deletePipeResponse = (DeletePipeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipe").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePipeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePipeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePipeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPipesClient.lambda$deletePipe$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePipeResponse describePipe(DescribePipeRequest describePipeRequest) throws InternalException, ValidationException, ThrottlingException, NotFoundException, AwsServiceException, SdkClientException, PipesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePipeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePipeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPipesClient.resolveMetricPublishers(clientConfiguration, describePipeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pipes");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePipe");
            DescribePipeResponse describePipeResponse = (DescribePipeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePipe").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePipeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePipeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePipeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPipesClient.lambda$describePipe$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipesResponse listPipes(ListPipesRequest listPipesRequest) throws InternalException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, PipesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPipesClient.resolveMetricPublishers(clientConfiguration, listPipesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pipes");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipes");
            ListPipesResponse listPipesResponse = (ListPipesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPipesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPipesClient.lambda$listPipes$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalException, ValidationException, NotFoundException, AwsServiceException, SdkClientException, PipesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPipesClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pipes");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPipesClient.lambda$listTagsForResource$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPipeResponse startPipe(StartPipeRequest startPipeRequest) throws InternalException, ValidationException, ThrottlingException, NotFoundException, ConflictException, AwsServiceException, SdkClientException, PipesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPipeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startPipeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPipesClient.resolveMetricPublishers(clientConfiguration, startPipeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pipes");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPipe");
            StartPipeResponse startPipeResponse = (StartPipeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPipe").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startPipeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartPipeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startPipeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPipesClient.lambda$startPipe$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopPipeResponse stopPipe(StopPipeRequest stopPipeRequest) throws InternalException, ValidationException, ThrottlingException, NotFoundException, ConflictException, AwsServiceException, SdkClientException, PipesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPipeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopPipeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPipesClient.resolveMetricPublishers(clientConfiguration, stopPipeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pipes");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopPipe");
            StopPipeResponse stopPipeResponse = (StopPipeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPipe").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopPipeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopPipeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopPipeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPipesClient.lambda$stopPipe$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalException, ValidationException, NotFoundException, AwsServiceException, SdkClientException, PipesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPipesClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pipes");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPipesClient.lambda$tagResource$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalException, ValidationException, NotFoundException, AwsServiceException, SdkClientException, PipesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPipesClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pipes");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPipesClient.lambda$untagResource$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipeResponse updatePipe(UpdatePipeRequest updatePipeRequest) throws InternalException, ValidationException, ThrottlingException, NotFoundException, ConflictException, AwsServiceException, SdkClientException, PipesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePipeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPipesClient.resolveMetricPublishers(clientConfiguration, updatePipeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pipes");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePipe");
            UpdatePipeResponse updatePipeResponse = (UpdatePipeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipe").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePipeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePipeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePipeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPipesClient.lambda$updatePipe$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "pipes";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        PipesServiceClientConfigurationBuilder serviceConfigBuilder = new PipesServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PipesException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final PipesServiceClientConfiguration serviceClientConfiguration() {
        return new PipesServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updatePipe$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopPipe$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPipe$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipes$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePipe$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePipe$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPipe$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

