/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Definition implements SdkPojo, Serializable, ToCopyableBuilder<Definition.Builder, Definition> {
    private static final SdkField<String> MODEL_HANDLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelHandle").getter(getter(Definition::modelHandle)).setter(setter(Builder::modelHandle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelHandle").build()).build();

    private static final SdkField<String> S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Url")
            .getter(getter(Definition::s3Url)).setter(setter(Builder::s3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()).build();

    private static final SdkField<Checksum> CHECKSUM_FIELD = SdkField.<Checksum> builder(MarshallingType.SDK_POJO)
            .memberName("Checksum").getter(getter(Definition::checksum)).setter(setter(Builder::checksum))
            .constructor(Checksum::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Checksum").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Definition::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_HANDLE_FIELD,
            S3_URL_FIELD, CHECKSUM_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelHandle;

    private final String s3Url;

    private final Checksum checksum;

    private final String state;

    private Definition(BuilderImpl builder) {
        this.modelHandle = builder.modelHandle;
        this.s3Url = builder.s3Url;
        this.checksum = builder.checksum;
        this.state = builder.state;
    }

    /**
     * <p>
     * The unique model handle.
     * </p>
     * 
     * @return The unique model handle.
     */
    public final String modelHandle() {
        return modelHandle;
    }

    /**
     * <p>
     * The absolute S3 location of the model.
     * </p>
     * 
     * @return The absolute S3 location of the model.
     */
    public final String s3Url() {
        return s3Url;
    }

    /**
     * <p>
     * The checksum information of the model.
     * </p>
     * 
     * @return The checksum information of the model.
     */
    public final Checksum checksum() {
        return checksum;
    }

    /**
     * <p>
     * The desired state of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ModelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The desired state of the model.
     * @see ModelState
     */
    public final ModelState state() {
        return ModelState.fromValue(state);
    }

    /**
     * <p>
     * The desired state of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ModelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The desired state of the model.
     * @see ModelState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelHandle());
        hashCode = 31 * hashCode + Objects.hashCode(s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Definition)) {
            return false;
        }
        Definition other = (Definition) obj;
        return Objects.equals(modelHandle(), other.modelHandle()) && Objects.equals(s3Url(), other.s3Url())
                && Objects.equals(checksum(), other.checksum()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Definition").add("ModelHandle", modelHandle()).add("S3Url", s3Url()).add("Checksum", checksum())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelHandle":
            return Optional.ofNullable(clazz.cast(modelHandle()));
        case "S3Url":
            return Optional.ofNullable(clazz.cast(s3Url()));
        case "Checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelHandle", MODEL_HANDLE_FIELD);
        map.put("S3Url", S3_URL_FIELD);
        map.put("Checksum", CHECKSUM_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Definition, T> g) {
        return obj -> g.apply((Definition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Definition> {
        /**
         * <p>
         * The unique model handle.
         * </p>
         * 
         * @param modelHandle
         *        The unique model handle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelHandle(String modelHandle);

        /**
         * <p>
         * The absolute S3 location of the model.
         * </p>
         * 
         * @param s3Url
         *        The absolute S3 location of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Url(String s3Url);

        /**
         * <p>
         * The checksum information of the model.
         * </p>
         * 
         * @param checksum
         *        The checksum information of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(Checksum checksum);

        /**
         * <p>
         * The checksum information of the model.
         * </p>
         * This is a convenience method that creates an instance of the {@link Checksum.Builder} avoiding the need to
         * create one manually via {@link Checksum#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Checksum.Builder#build()} is called immediately and its result is
         * passed to {@link #checksum(Checksum)}.
         * 
         * @param checksum
         *        a consumer that will call methods on {@link Checksum.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checksum(Checksum)
         */
        default Builder checksum(Consumer<Checksum.Builder> checksum) {
            return checksum(Checksum.builder().applyMutation(checksum).build());
        }

        /**
         * <p>
         * The desired state of the model.
         * </p>
         * 
         * @param state
         *        The desired state of the model.
         * @see ModelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelState
         */
        Builder state(String state);

        /**
         * <p>
         * The desired state of the model.
         * </p>
         * 
         * @param state
         *        The desired state of the model.
         * @see ModelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelState
         */
        Builder state(ModelState state);
    }

    static final class BuilderImpl implements Builder {
        private String modelHandle;

        private String s3Url;

        private Checksum checksum;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Definition model) {
            modelHandle(model.modelHandle);
            s3Url(model.s3Url);
            checksum(model.checksum);
            state(model.state);
        }

        public final String getModelHandle() {
            return modelHandle;
        }

        public final void setModelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
        }

        @Override
        public final Builder modelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
            return this;
        }

        public final String getS3Url() {
            return s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final Checksum.Builder getChecksum() {
            return checksum != null ? checksum.toBuilder() : null;
        }

        public final void setChecksum(Checksum.BuilderImpl checksum) {
            this.checksum = checksum != null ? checksum.build() : null;
        }

        @Override
        public final Builder checksum(Checksum checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ModelState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Definition build() {
            return new Definition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
