/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakeredge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceRegistrationResponse extends SagemakerEdgeResponse implements
        ToCopyableBuilder<GetDeviceRegistrationResponse.Builder, GetDeviceRegistrationResponse> {
    private static final SdkField<String> DEVICE_REGISTRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceRegistration").getter(getter(GetDeviceRegistrationResponse::deviceRegistration))
            .setter(setter(Builder::deviceRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceRegistration").build())
            .build();

    private static final SdkField<String> CACHE_TTL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheTTL").getter(getter(GetDeviceRegistrationResponse::cacheTTL)).setter(setter(Builder::cacheTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheTTL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_REGISTRATION_FIELD,
            CACHE_TTL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String deviceRegistration;

    private final String cacheTTL;

    private GetDeviceRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.deviceRegistration = builder.deviceRegistration;
        this.cacheTTL = builder.cacheTTL;
    }

    /**
     * <p>
     * Describes if the device is currently registered with SageMaker Edge Manager.
     * </p>
     * 
     * @return Describes if the device is currently registered with SageMaker Edge Manager.
     */
    public final String deviceRegistration() {
        return deviceRegistration;
    }

    /**
     * <p>
     * The amount of time, in seconds, that the registration status is stored on the device’s cache before it is
     * refreshed.
     * </p>
     * 
     * @return The amount of time, in seconds, that the registration status is stored on the device’s cache before it is
     *         refreshed.
     */
    public final String cacheTTL() {
        return cacheTTL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceRegistration());
        hashCode = 31 * hashCode + Objects.hashCode(cacheTTL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceRegistrationResponse)) {
            return false;
        }
        GetDeviceRegistrationResponse other = (GetDeviceRegistrationResponse) obj;
        return Objects.equals(deviceRegistration(), other.deviceRegistration()) && Objects.equals(cacheTTL(), other.cacheTTL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeviceRegistrationResponse").add("DeviceRegistration", deviceRegistration())
                .add("CacheTTL", cacheTTL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceRegistration":
            return Optional.ofNullable(clazz.cast(deviceRegistration()));
        case "CacheTTL":
            return Optional.ofNullable(clazz.cast(cacheTTL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceRegistration", DEVICE_REGISTRATION_FIELD);
        map.put("CacheTTL", CACHE_TTL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceRegistrationResponse, T> g) {
        return obj -> g.apply((GetDeviceRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SagemakerEdgeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeviceRegistrationResponse> {
        /**
         * <p>
         * Describes if the device is currently registered with SageMaker Edge Manager.
         * </p>
         * 
         * @param deviceRegistration
         *        Describes if the device is currently registered with SageMaker Edge Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceRegistration(String deviceRegistration);

        /**
         * <p>
         * The amount of time, in seconds, that the registration status is stored on the device’s cache before it is
         * refreshed.
         * </p>
         * 
         * @param cacheTTL
         *        The amount of time, in seconds, that the registration status is stored on the device’s cache before it
         *        is refreshed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheTTL(String cacheTTL);
    }

    static final class BuilderImpl extends SagemakerEdgeResponse.BuilderImpl implements Builder {
        private String deviceRegistration;

        private String cacheTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceRegistrationResponse model) {
            super(model);
            deviceRegistration(model.deviceRegistration);
            cacheTTL(model.cacheTTL);
        }

        public final String getDeviceRegistration() {
            return deviceRegistration;
        }

        public final void setDeviceRegistration(String deviceRegistration) {
            this.deviceRegistration = deviceRegistration;
        }

        @Override
        public final Builder deviceRegistration(String deviceRegistration) {
            this.deviceRegistration = deviceRegistration;
            return this;
        }

        public final String getCacheTTL() {
            return cacheTTL;
        }

        public final void setCacheTTL(String cacheTTL) {
            this.cacheTTL = cacheTTL;
        }

        @Override
        public final Builder cacheTTL(String cacheTTL) {
            this.cacheTTL = cacheTTL;
            return this;
        }

        @Override
        public GetDeviceRegistrationResponse build() {
            return new GetDeviceRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
