/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.auth.policy.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import software.amazon.awssdk.utils.FunctionalUtils;

public final class JacksonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JacksonUtils() {
    }

    public static <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        return (T)FunctionalUtils.invokeSafely(() -> OBJECT_MAPPER.readValue(json, clazz));
    }

    public static JsonNode jsonNodeOf(String json) {
        return JacksonUtils.fromJsonString(json, JsonNode.class);
    }

    public static JsonGenerator jsonGeneratorOf(Writer writer) throws IOException {
        return new JsonFactory().createGenerator(writer);
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

