/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ForwardedIPConfig;
import software.amazon.awssdk.services.wafv2.model.RateBasedStatementAggregateKeyType;
import software.amazon.awssdk.services.wafv2.model.RateBasedStatementCustomKey;
import software.amazon.awssdk.services.wafv2.model.RateBasedStatementCustomKeysCopier;
import software.amazon.awssdk.services.wafv2.model.Statement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RateBasedStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RateBasedStatement> {
    private static final SdkField<Long> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Limit").getter(RateBasedStatement.getter(RateBasedStatement::limit)).setter(RateBasedStatement.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<Long> EVALUATION_WINDOW_SEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EvaluationWindowSec").getter(RateBasedStatement.getter(RateBasedStatement::evaluationWindowSec)).setter(RateBasedStatement.setter(Builder::evaluationWindowSec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationWindowSec").build()}).build();
    private static final SdkField<String> AGGREGATE_KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregateKeyType").getter(RateBasedStatement.getter(RateBasedStatement::aggregateKeyTypeAsString)).setter(RateBasedStatement.setter(Builder::aggregateKeyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateKeyType").build()}).build();
    private static final SdkField<Statement> SCOPE_DOWN_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScopeDownStatement").getter(RateBasedStatement.getter(RateBasedStatement::scopeDownStatement)).setter(RateBasedStatement.setter(Builder::scopeDownStatement)).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeDownStatement").build()}).build();
    private static final SdkField<ForwardedIPConfig> FORWARDED_IP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForwardedIPConfig").getter(RateBasedStatement.getter(RateBasedStatement::forwardedIPConfig)).setter(RateBasedStatement.setter(Builder::forwardedIPConfig)).constructor(ForwardedIPConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedIPConfig").build()}).build();
    private static final SdkField<List<RateBasedStatementCustomKey>> CUSTOM_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomKeys").getter(RateBasedStatement.getter(RateBasedStatement::customKeys)).setter(RateBasedStatement.setter(Builder::customKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RateBasedStatementCustomKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, EVALUATION_WINDOW_SEC_FIELD, AGGREGATE_KEY_TYPE_FIELD, SCOPE_DOWN_STATEMENT_FIELD, FORWARDED_IP_CONFIG_FIELD, CUSTOM_KEYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long limit;
    private final Long evaluationWindowSec;
    private final String aggregateKeyType;
    private final Statement scopeDownStatement;
    private final ForwardedIPConfig forwardedIPConfig;
    private final List<RateBasedStatementCustomKey> customKeys;

    private RateBasedStatement(BuilderImpl builder) {
        this.limit = builder.limit;
        this.evaluationWindowSec = builder.evaluationWindowSec;
        this.aggregateKeyType = builder.aggregateKeyType;
        this.scopeDownStatement = builder.scopeDownStatement;
        this.forwardedIPConfig = builder.forwardedIPConfig;
        this.customKeys = builder.customKeys;
    }

    public final Long limit() {
        return this.limit;
    }

    public final Long evaluationWindowSec() {
        return this.evaluationWindowSec;
    }

    public final RateBasedStatementAggregateKeyType aggregateKeyType() {
        return RateBasedStatementAggregateKeyType.fromValue(this.aggregateKeyType);
    }

    public final String aggregateKeyTypeAsString() {
        return this.aggregateKeyType;
    }

    public final Statement scopeDownStatement() {
        return this.scopeDownStatement;
    }

    public final ForwardedIPConfig forwardedIPConfig() {
        return this.forwardedIPConfig;
    }

    public final boolean hasCustomKeys() {
        return this.customKeys != null && !(this.customKeys instanceof SdkAutoConstructList);
    }

    public final List<RateBasedStatementCustomKey> customKeys() {
        return this.customKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationWindowSec());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateKeyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeDownStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedIPConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomKeys() ? this.customKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateBasedStatement)) {
            return false;
        }
        RateBasedStatement other = (RateBasedStatement)obj;
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.evaluationWindowSec(), other.evaluationWindowSec()) && Objects.equals(this.aggregateKeyTypeAsString(), other.aggregateKeyTypeAsString()) && Objects.equals(this.scopeDownStatement(), other.scopeDownStatement()) && Objects.equals(this.forwardedIPConfig(), other.forwardedIPConfig()) && this.hasCustomKeys() == other.hasCustomKeys() && Objects.equals(this.customKeys(), other.customKeys());
    }

    public final String toString() {
        return ToString.builder((String)"RateBasedStatement").add("Limit", (Object)this.limit()).add("EvaluationWindowSec", (Object)this.evaluationWindowSec()).add("AggregateKeyType", (Object)this.aggregateKeyTypeAsString()).add("ScopeDownStatement", (Object)this.scopeDownStatement()).add("ForwardedIPConfig", (Object)this.forwardedIPConfig()).add("CustomKeys", this.hasCustomKeys() ? this.customKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "EvaluationWindowSec": {
                return Optional.ofNullable(clazz.cast(this.evaluationWindowSec()));
            }
            case "AggregateKeyType": {
                return Optional.ofNullable(clazz.cast(this.aggregateKeyTypeAsString()));
            }
            case "ScopeDownStatement": {
                return Optional.ofNullable(clazz.cast(this.scopeDownStatement()));
            }
            case "ForwardedIPConfig": {
                return Optional.ofNullable(clazz.cast(this.forwardedIPConfig()));
            }
            case "CustomKeys": {
                return Optional.ofNullable(clazz.cast(this.customKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RateBasedStatement, T> g) {
        return obj -> g.apply((RateBasedStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long limit;
        private Long evaluationWindowSec;
        private String aggregateKeyType;
        private Statement scopeDownStatement;
        private ForwardedIPConfig forwardedIPConfig;
        private List<RateBasedStatementCustomKey> customKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RateBasedStatement model) {
            this.limit(model.limit);
            this.evaluationWindowSec(model.evaluationWindowSec);
            this.aggregateKeyType(model.aggregateKeyType);
            this.scopeDownStatement(model.scopeDownStatement);
            this.forwardedIPConfig(model.forwardedIPConfig);
            this.customKeys(model.customKeys);
        }

        public final Long getLimit() {
            return this.limit;
        }

        public final void setLimit(Long limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public final Long getEvaluationWindowSec() {
            return this.evaluationWindowSec;
        }

        public final void setEvaluationWindowSec(Long evaluationWindowSec) {
            this.evaluationWindowSec = evaluationWindowSec;
        }

        @Override
        public final Builder evaluationWindowSec(Long evaluationWindowSec) {
            this.evaluationWindowSec = evaluationWindowSec;
            return this;
        }

        public final String getAggregateKeyType() {
            return this.aggregateKeyType;
        }

        public final void setAggregateKeyType(String aggregateKeyType) {
            this.aggregateKeyType = aggregateKeyType;
        }

        @Override
        public final Builder aggregateKeyType(String aggregateKeyType) {
            this.aggregateKeyType = aggregateKeyType;
            return this;
        }

        @Override
        public final Builder aggregateKeyType(RateBasedStatementAggregateKeyType aggregateKeyType) {
            this.aggregateKeyType(aggregateKeyType == null ? null : aggregateKeyType.toString());
            return this;
        }

        public final Statement.Builder getScopeDownStatement() {
            return this.scopeDownStatement != null ? this.scopeDownStatement.toBuilder() : null;
        }

        public final void setScopeDownStatement(Statement.BuilderImpl scopeDownStatement) {
            this.scopeDownStatement = scopeDownStatement != null ? scopeDownStatement.build() : null;
        }

        @Override
        public final Builder scopeDownStatement(Statement scopeDownStatement) {
            this.scopeDownStatement = scopeDownStatement;
            return this;
        }

        public final ForwardedIPConfig.Builder getForwardedIPConfig() {
            return this.forwardedIPConfig != null ? this.forwardedIPConfig.toBuilder() : null;
        }

        public final void setForwardedIPConfig(ForwardedIPConfig.BuilderImpl forwardedIPConfig) {
            this.forwardedIPConfig = forwardedIPConfig != null ? forwardedIPConfig.build() : null;
        }

        @Override
        public final Builder forwardedIPConfig(ForwardedIPConfig forwardedIPConfig) {
            this.forwardedIPConfig = forwardedIPConfig;
            return this;
        }

        public final List<RateBasedStatementCustomKey.Builder> getCustomKeys() {
            List<RateBasedStatementCustomKey.Builder> result = RateBasedStatementCustomKeysCopier.copyToBuilder(this.customKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomKeys(Collection<RateBasedStatementCustomKey.BuilderImpl> customKeys) {
            this.customKeys = RateBasedStatementCustomKeysCopier.copyFromBuilder(customKeys);
        }

        @Override
        public final Builder customKeys(Collection<RateBasedStatementCustomKey> customKeys) {
            this.customKeys = RateBasedStatementCustomKeysCopier.copy(customKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customKeys(RateBasedStatementCustomKey ... customKeys) {
            this.customKeys(Arrays.asList(customKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customKeys(Consumer<RateBasedStatementCustomKey.Builder> ... customKeys) {
            this.customKeys(Stream.of(customKeys).map(c -> (RateBasedStatementCustomKey)((RateBasedStatementCustomKey.Builder)RateBasedStatementCustomKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RateBasedStatement build() {
            return new RateBasedStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RateBasedStatement> {
        public Builder limit(Long var1);

        public Builder evaluationWindowSec(Long var1);

        public Builder aggregateKeyType(String var1);

        public Builder aggregateKeyType(RateBasedStatementAggregateKeyType var1);

        public Builder scopeDownStatement(Statement var1);

        default public Builder scopeDownStatement(Consumer<Statement.Builder> scopeDownStatement) {
            return this.scopeDownStatement((Statement)((Statement.Builder)Statement.builder().applyMutation(scopeDownStatement)).build());
        }

        public Builder forwardedIPConfig(ForwardedIPConfig var1);

        default public Builder forwardedIPConfig(Consumer<ForwardedIPConfig.Builder> forwardedIPConfig) {
            return this.forwardedIPConfig((ForwardedIPConfig)((ForwardedIPConfig.Builder)ForwardedIPConfig.builder().applyMutation(forwardedIPConfig)).build());
        }

        public Builder customKeys(Collection<RateBasedStatementCustomKey> var1);

        public Builder customKeys(RateBasedStatementCustomKey ... var1);

        public Builder customKeys(Consumer<RateBasedStatementCustomKey.Builder> ... var1);
    }
}

