/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BundleAssociatedResourceType {
    APPLICATION("APPLICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BundleAssociatedResourceType> VALUE_MAP;
    private final String value;

    private BundleAssociatedResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BundleAssociatedResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BundleAssociatedResourceType> knownValues() {
        EnumSet<BundleAssociatedResourceType> knownValues = EnumSet.allOf(BundleAssociatedResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BundleAssociatedResourceType.class, BundleAssociatedResourceType::toString);
    }
}

