/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure.paginate;

public class PaginationData {
    private int itemFromIndex;
    private int itemToIndex;
    private int itemsPerPage;

    PaginationData(int itemFromIndex, int itemToIndex, int itemsPerPage) {
        this.itemFromIndex = itemFromIndex;
        this.itemToIndex = itemToIndex;
        this.itemsPerPage = itemsPerPage;
    }

    public static PaginationDataBuilder builder() {
        return new PaginationDataBuilder();
    }

    public int getItemFromIndex() {
        return this.itemFromIndex;
    }

    public int getItemToIndex() {
        return this.itemToIndex;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setItemFromIndex(int itemFromIndex) {
        this.itemFromIndex = itemFromIndex;
    }

    public void setItemToIndex(int itemToIndex) {
        this.itemToIndex = itemToIndex;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaginationData)) {
            return false;
        }
        PaginationData other = (PaginationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getItemFromIndex() != other.getItemFromIndex()) {
            return false;
        }
        if (this.getItemToIndex() != other.getItemToIndex()) {
            return false;
        }
        return this.getItemsPerPage() == other.getItemsPerPage();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaginationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getItemFromIndex();
        result = result * 59 + this.getItemToIndex();
        result = result * 59 + this.getItemsPerPage();
        return result;
    }

    public String toString() {
        return "PaginationData(itemFromIndex=" + this.getItemFromIndex() + ", itemToIndex=" + this.getItemToIndex() + ", itemsPerPage=" + this.getItemsPerPage() + ")";
    }

    public static class PaginationDataBuilder {
        private int itemFromIndex;
        private int itemToIndex;
        private int itemsPerPage;

        PaginationDataBuilder() {
        }

        public PaginationDataBuilder itemFromIndex(int itemFromIndex) {
            this.itemFromIndex = itemFromIndex;
            return this;
        }

        public PaginationDataBuilder itemToIndex(int itemToIndex) {
            this.itemToIndex = itemToIndex;
            return this;
        }

        public PaginationDataBuilder itemsPerPage(int itemsPerPage) {
            this.itemsPerPage = itemsPerPage;
            return this;
        }

        public PaginationData build() {
            return new PaginationData(this.itemFromIndex, this.itemToIndex, this.itemsPerPage);
        }

        public String toString() {
            return "PaginationData.PaginationDataBuilder(itemFromIndex=" + this.itemFromIndex + ", itemToIndex=" + this.itemToIndex + ", itemsPerPage=" + this.itemsPerPage + ")";
        }
    }
}

