/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.scenario;

import java.util.List;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.section.scenario.ScenarioDisplay;
import tech.grasshopper.pdf.structure.paginate.PaginatedSection;
import tech.grasshopper.pdf.structure.paginate.PaginationData;
import tech.grasshopper.pdf.structure.paginate.ScenarioPaginator;

public class ScenarioSection
extends PaginatedSection {
    static final String SECTION_TITLE = "SCENARIOS SUMMARY";
    private final int maxScenariosPerPage;
    private ScenarioData scenarioData;

    @Override
    public void createSection() {
        this.scenarioData = (ScenarioData)this.displayData;
        ScenarioPaginator paginator = ScenarioPaginator.builder().data(this.scenarioData).maxScenariosPerPage(this.maxScenariosPerPage).section(this).build();
        paginator.paginate();
    }

    @Override
    public void generateDisplay(int fromIndex, int toIndex) {
        ((ScenarioDisplay)((ScenarioDisplay.ScenarioDisplayBuilder)((ScenarioDisplay.ScenarioDisplayBuilder)((ScenarioDisplay.ScenarioDisplayBuilder)((ScenarioDisplay.ScenarioDisplayBuilder)((ScenarioDisplay.ScenarioDisplayBuilder)ScenarioDisplay.builder().displayData(this.createDisplayData(fromIndex, toIndex))).document(this.document)).reportConfig(this.reportConfig)).destinations(this.destinations)).paginationData(PaginationData.builder().itemsPerPage(this.maxScenariosPerPage).itemFromIndex(fromIndex).itemToIndex(toIndex).build())).build()).display();
    }

    @Override
    public DisplayData createDisplayData(int fromIndex, int toIndex) {
        List<Scenario> pageScenarios = this.scenarioData.getScenarios().subList(fromIndex, toIndex);
        return ScenarioData.builder().scenarios(pageScenarios).build();
    }

    protected ScenarioSection(ScenarioSectionBuilder<?, ?> b) {
        super((PaginatedSection.PaginatedSectionBuilder<?, ?>)b);
        this.maxScenariosPerPage = this.reportConfig.getScenarioConfig().scenarioCount();
        this.scenarioData = ((ScenarioSectionBuilder)b).scenarioData;
    }

    public static ScenarioSectionBuilder<?, ?> builder() {
        return new ScenarioSectionBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScenarioSection)) {
            return false;
        }
        ScenarioSection other = (ScenarioSection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxScenariosPerPage != other.maxScenariosPerPage) {
            return false;
        }
        ScenarioData this$scenarioData = this.scenarioData;
        ScenarioData other$scenarioData = other.scenarioData;
        return !(this$scenarioData == null ? other$scenarioData != null : !this$scenarioData.equals(other$scenarioData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScenarioSection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxScenariosPerPage;
        ScenarioData $scenarioData = this.scenarioData;
        result = result * 59 + ($scenarioData == null ? 43 : $scenarioData.hashCode());
        return result;
    }

    private static final class ScenarioSectionBuilderImpl
    extends ScenarioSectionBuilder<ScenarioSection, ScenarioSectionBuilderImpl> {
        private ScenarioSectionBuilderImpl() {
        }

        @Override
        protected ScenarioSectionBuilderImpl self() {
            return this;
        }

        @Override
        public ScenarioSection build() {
            return new ScenarioSection(this);
        }
    }

    public static abstract class ScenarioSectionBuilder<C extends ScenarioSection, B extends ScenarioSectionBuilder<C, B>>
    extends PaginatedSection.PaginatedSectionBuilder<C, B> {
        private ScenarioData scenarioData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B scenarioData(ScenarioData scenarioData) {
            this.scenarioData = scenarioData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScenarioSection.ScenarioSectionBuilder(super=" + super.toString() + ", scenarioData=" + this.scenarioData + ")";
        }
    }
}

