/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatComparators;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatRBTreeSet;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.FloatColumnType;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class FloatColumn
extends NumberColumn<FloatColumn, Float> {
    protected final FloatArrayList data;

    private FloatColumn(String name, FloatArrayList data) {
        super(FloatColumnType.instance(), name, FloatColumnType.DEFAULT_PARSER);
        this.setPrintFormatter(NumberColumnFormatter.floatingPointDefault());
        this.data = data;
    }

    @Override
    public String getString(int row) {
        float value = this.getFloat(row);
        return this.getPrintFormatter().format(value);
    }

    @Override
    public int valueHash(int rowNumber) {
        return Float.hashCode(this.getFloat(rowNumber));
    }

    @Override
    public boolean equals(int rowNumber1, int rowNumber2) {
        return this.getFloat(rowNumber1) == this.getFloat(rowNumber2);
    }

    public static FloatColumn create(String name) {
        return new FloatColumn(name, new FloatArrayList());
    }

    public static FloatColumn create(String name, float ... arr) {
        return new FloatColumn(name, new FloatArrayList(arr));
    }

    public static FloatColumn create(String name, int initialSize) {
        FloatColumn column = new FloatColumn(name, new FloatArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static FloatColumn create(String name, Float[] arr) {
        FloatColumn column = FloatColumn.create(name);
        for (Float val : arr) {
            column.append(val);
        }
        return column;
    }

    public static FloatColumn create(String name, Stream<Float> stream) {
        FloatColumn column = FloatColumn.create(name);
        stream.forEach(column::append);
        return column;
    }

    @Override
    public FloatColumn createCol(String name, int initialSize) {
        return FloatColumn.create(name, initialSize);
    }

    @Override
    public FloatColumn createCol(String name) {
        return FloatColumn.create(name);
    }

    @Override
    public Float get(int index) {
        float result = this.getFloat(index);
        return this.isMissingValue(result) ? null : Float.valueOf(result);
    }

    public static boolean valueIsMissing(float value) {
        return FloatColumnType.valueIsMissing(value);
    }

    @Override
    public FloatColumn subset(int[] rows) {
        FloatColumn c = (FloatColumn)this.emptyCopy();
        for (int row : rows) {
            c.append(this.getFloat(row));
        }
        return c;
    }

    public Selection isNotIn(float ... numbers) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(numbers));
        return results;
    }

    public Selection isIn(float ... numbers) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        FloatRBTreeSet doubleSet = new FloatRBTreeSet(numbers);
        for (int i = 0; i < this.size(); ++i) {
            if (!doubleSet.contains(this.getFloat(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public FloatColumn unique() {
        FloatOpenHashSet values = new FloatOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            values.add(this.getFloat(i));
        }
        FloatColumn column = FloatColumn.create(this.name() + " Unique values");
        FloatIterator floatIterator = values.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            column.append(value);
        }
        return column;
    }

    public FloatColumn top(int n) {
        FloatArrayList top = new FloatArrayList();
        float[] values = this.data.toFloatArray();
        FloatArrays.parallelQuickSort((float[])values, (FloatComparator)FloatComparators.OPPOSITE_COMPARATOR);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return new FloatColumn(this.name() + "[Top " + n + "]", top);
    }

    public FloatColumn bottom(int n) {
        FloatArrayList bottom = new FloatArrayList();
        float[] values = this.data.toFloatArray();
        FloatArrays.parallelQuickSort((float[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return new FloatColumn(this.name() + "[Bottoms " + n + "]", bottom);
    }

    @Override
    public FloatColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : -n;
        float[] dest = new float[this.size()];
        int destPos = Math.max(n, 0);
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = FloatColumnType.missingValueIndicator();
        }
        float[] array = this.data.toFloatArray();
        System.arraycopy(array, srcPos, dest, destPos, length);
        return new FloatColumn(this.name() + " lag(" + n + ")", new FloatArrayList(dest));
    }

    public FloatColumn removeMissing() {
        FloatColumn result = this.copy();
        result.clear();
        FloatListIterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            float v = iterator.nextFloat();
            if (this.isMissingValue(v)) continue;
            result.append(v);
        }
        return result;
    }

    public FloatColumn append(float i) {
        this.data.add(i);
        return this;
    }

    public FloatColumn append(Float val) {
        if (val == null) {
            this.appendMissing();
        } else {
            this.append(val.floatValue());
        }
        return this;
    }

    @Override
    public FloatColumn copy() {
        FloatColumn copy = new FloatColumn(this.name(), this.data.clone());
        copy.setPrintFormatter(this.getPrintFormatter());
        copy.locale = this.locale;
        return copy;
    }

    @Override
    public Iterator<Float> iterator() {
        return this.data.iterator();
    }

    public float[] asFloatArray() {
        return this.data.toFloatArray();
    }

    public Float[] asObjectArray() {
        Float[] output = new Float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = !this.isMissing(i) ? Float.valueOf(this.getFloat(i)) : null;
        }
        return output;
    }

    @Override
    public int compare(Float o1, Float o2) {
        return Float.compare(o1.floatValue(), o2.floatValue());
    }

    public FloatColumn set(int i, Float val) {
        return val == null ? this.setMissing(i) : this.set(i, val.floatValue());
    }

    public FloatColumn set(int i, float val) {
        this.data.set(i, val);
        return this;
    }

    @Override
    public Column<Float> set(int row, String stringValue, AbstractColumnParser<?> parser) {
        return this.set(row, parser.parseFloat(stringValue));
    }

    public FloatColumn append(Column<Float> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0, (String)"Column '%s' has type %s, but column '%s' has type %s.", (Object)this.name(), (Object)this.type(), (Object)column.name(), (Object)column.type());
        FloatColumn numberColumn = (FloatColumn)column;
        int size = numberColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(numberColumn.getFloat(i));
        }
        return this;
    }

    public FloatColumn append(Column<Float> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0, (String)"Column '%s' has type %s, but column '%s' has type %s.", (Object)this.name(), (Object)this.type(), (Object)column.name(), (Object)column.type());
        return this.append(((FloatColumn)column).getFloat(row));
    }

    public FloatColumn set(int row, Column<Float> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0, (String)"Column '%s' has type %s, but column '%s' has type %s.", (Object)this.name(), (Object)this.type(), (Object)column.name(), (Object)column.type());
        return this.set(row, ((FloatColumn)column).getFloat(sourceRow));
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(FloatColumnType.instance().byteSize()).putFloat(this.getFloat(rowNumber)).array();
    }

    @Override
    public int countUnique() {
        FloatOpenHashSet uniqueElements = new FloatOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            uniqueElements.add(this.getFloat(i));
        }
        return uniqueElements.size();
    }

    @Override
    public double getDouble(int row) {
        float value = this.data.getFloat(row);
        if (this.isMissingValue(value)) {
            return FloatColumnType.missingValueIndicator();
        }
        return value;
    }

    public float getFloat(int row) {
        return this.data.getFloat(row);
    }

    public boolean isMissingValue(float value) {
        return FloatColumnType.valueIsMissing(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.isMissingValue(this.getFloat(rowNumber));
    }

    public FloatColumn setMissing(int i) {
        return this.set(i, FloatColumnType.missingValueIndicator());
    }

    @Override
    public void sortAscending() {
        this.data.sort(FloatComparators.NATURAL_COMPARATOR);
    }

    @Override
    public void sortDescending() {
        this.data.sort(FloatComparators.OPPOSITE_COMPARATOR);
    }

    public FloatColumn appendMissing() {
        return this.append(FloatColumnType.missingValueIndicator());
    }

    public FloatColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof Float) {
            return this.append(((Float)obj).floatValue());
        }
        throw new IllegalArgumentException("Could not append " + obj.getClass());
    }

    public FloatColumn appendCell(String value) {
        try {
            return this.append(this.parser().parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    public FloatColumn appendCell(String value, AbstractColumnParser<?> parser) {
        try {
            return this.append(parser.parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    @Override
    public String getUnformattedString(int row) {
        float value = this.getFloat(row);
        if (FloatColumnType.valueIsMissing(value)) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public LongColumn asLongColumn() {
        LongColumn result = LongColumn.create(this.name());
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float d = ((Float)floatListIterator.next()).floatValue();
            if (FloatColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append((long)d);
        }
        return result;
    }

    @Override
    public IntColumn asIntColumn() {
        IntColumn result = IntColumn.create(this.name());
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float d = ((Float)floatListIterator.next()).floatValue();
            if (FloatColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append((int)d);
        }
        return result;
    }

    @Override
    public ShortColumn asShortColumn() {
        ShortColumn result = ShortColumn.create(this.name());
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float d = ((Float)floatListIterator.next()).floatValue();
            if (FloatColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append((short)d);
        }
        return result;
    }

    @Override
    public DoubleColumn asDoubleColumn() {
        DoubleColumn result = DoubleColumn.create(this.name());
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float d = ((Float)floatListIterator.next()).floatValue();
            if (FloatColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append(d);
        }
        return result;
    }

    @Override
    public Set<Float> asSet() {
        return new HashSet<Float>(this.unique().asList());
    }
}

