/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.RuntimeIOException;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.io.csv.CsvReader;
import tech.tablesaw.io.jdbc.SqlResultSetReader;

public class DataFrameReader {
    private final ReaderRegistry registry;

    public DataFrameReader(ReaderRegistry registry) {
        this.registry = registry;
    }

    public Table url(String url) {
        try {
            return this.url(new URL(url));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public Table url(URL url) {
        URLConnection connection = null;
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String contentType = connection.getContentType();
        return this.url(url, this.getCharset(contentType), this.getMimeType(contentType));
    }

    private Table url(URL url, Charset charset, String mimeType) {
        Optional<DataReader<?>> reader = this.registry.getReaderForMimeType(mimeType);
        if (reader.isPresent()) {
            return this.readUrl(url, charset, reader.get());
        }
        reader = this.registry.getReaderForExtension(this.getExtension(url));
        if (reader.isPresent()) {
            return this.readUrl(url, charset, reader.get());
        }
        throw new IllegalArgumentException("No reader registered for mime-type " + mimeType);
    }

    private Table readUrl(URL url, Charset charset, DataReader<?> reader) {
        try {
            return reader.read(new Source(url.openConnection().getInputStream(), charset));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private String getMimeType(String contentType) {
        String[] pair = contentType.split(";");
        return pair[0].trim();
    }

    private Charset getCharset(String contentType) {
        String[] pair = contentType.split(";");
        return pair.length == 1 ? Charset.defaultCharset() : Charset.forName(pair[1].split("=")[1].trim());
    }

    private String getExtension(URL url) {
        return Files.getFileExtension((String)url.getPath());
    }

    public Table string(String s, String fileExtension) {
        Optional<DataReader<?>> reader = this.registry.getReaderForExtension(fileExtension);
        if (!reader.isPresent()) {
            throw new IllegalArgumentException("No reader registered for extension " + fileExtension);
        }
        return reader.get().read(Source.fromString(s));
    }

    public Table file(String file) {
        return this.file(new File(file));
    }

    public Table file(File file) {
        String extension = null;
        try {
            extension = Files.getFileExtension((String)file.getCanonicalPath());
            Optional<DataReader<?>> reader = this.registry.getReaderForExtension(extension);
            if (reader.isPresent()) {
                return reader.get().read(new Source(file));
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        throw new IllegalArgumentException("No reader registered for extension " + extension);
    }

    public <T extends ReadOptions> Table usingOptions(T options) {
        DataReader<T> reader = this.registry.getReaderForOptions(options);
        return reader.read(options);
    }

    public Table usingOptions(ReadOptions.Builder builder) {
        return this.usingOptions(builder.build());
    }

    public Table db(ResultSet resultSet) throws SQLException {
        return SqlResultSetReader.read(resultSet);
    }

    public Table db(ResultSet resultSet, String tableName) throws SQLException {
        Table table = SqlResultSetReader.read(resultSet);
        table.setName(tableName);
        return table;
    }

    public Table csv(String file) {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(String contents, String tableName) {
        try {
            return this.csv(CsvReadOptions.builder(new StringReader(contents)).tableName(tableName));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Table csv(File file) {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(InputStream stream) {
        return this.csv(CsvReadOptions.builder(stream));
    }

    public Table csv(URL url) {
        try {
            return this.readUrl(url, this.getCharset(url.openConnection().getContentType()), new CsvReader());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public Table csv(InputStream stream, String name) {
        return this.csv(CsvReadOptions.builder(stream).tableName(name));
    }

    public Table csv(Reader reader) {
        return this.csv(CsvReadOptions.builder(reader));
    }

    public Table csv(CsvReadOptions.Builder options) {
        return this.csv(options.build());
    }

    public Table csv(CsvReadOptions options) {
        return new CsvReader().read(options);
    }
}

