/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries;

import java.util.List;
import java.util.ArrayList;

import javax.persistence.QueryHint;
import javax.persistence.NamedQuery;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;

/**
 * Object to hold onto a named query metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataNamedQuery extends MetadataQuery {
    protected NamedQuery m_namedQuery;
    
    /**
     * INTERNAL:
     */
    protected MetadataNamedQuery() {}

    /**
     * INTERNAL:
     */
    public MetadataNamedQuery(NamedQuery namedQuery, Class javaClass) {
        super(javaClass);
        
        m_namedQuery = namedQuery;
    }
    
    /**
     * INTERNAL:
     */
    public String getEJBQLString() {
        return m_namedQuery.query();
    }
    
    /**
     * INTERNAL:
     */
    public List<MetadataQueryHint> getHints() {
        if (m_hints == null) {
            m_hints = new ArrayList<MetadataQueryHint>();
            
            for (QueryHint hint : m_namedQuery.hints()) {
                m_hints.add(new MetadataQueryHint(hint));
            }     
        }
        
        return m_hints; 
    }
    
    /**
     * INTERNAL:
     */
    public String getIgnoreLogMessageContext() {
        return MetadataLogger.IGNORE_NAMED_QUERY_ANNOTATION;
    }
    
    /**
     * INTERNAL:
     */
    public String getName() {
        return m_namedQuery.name();
    }
}
