/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Metadata object to hold generated value information.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataGeneratedValue {
    private GeneratedValue m_generatedValue;
    public static final String DEFAULT_STRATEGY = GenerationType.AUTO.name();
    
    /**
     * INTERNAL:
     */
    public MetadataGeneratedValue() {}
    
    /**
     * INTERNAL:
     */
    public MetadataGeneratedValue(GeneratedValue generatedValue) {
        m_generatedValue = generatedValue;
    }
    
    /**
     * INTERNAL:
     */
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof MetadataGeneratedValue) {
            MetadataGeneratedValue generatedValue = (MetadataGeneratedValue) objectToCompare;
            if (!generatedValue.getStrategy().equals(getStrategy())) {
                return false;
            }
            
            return generatedValue.getGenerator().equals(getGenerator());
        }
        
        return false;
    }
    
    /**
     * INTERNAL: (Overridden in XMLGeneratedValue)
     */
    public String getStrategy() {
        return m_generatedValue.strategy().name();
    }
    
    /**
     * INTERNAL: (Overridden in XMLGeneratedValue)
     */
    public String getGenerator() {
        return m_generatedValue.generator();
    }
}
