/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.queryframework.*;
import oracle.toplink.essentials.expressions.*;

/**
 * INTERNAL:
 * This node contains the information about what kind of query is represented it's tree
 * (e.g. Select, Update etc.)
 * Subclasses of this node will contain query specific behavior.
 */
public abstract class QueryNode extends MajorNode {
    private ParseTree parseTree;

    public QueryNode() {
        super();
    }

    /**
     * INTERNAL
     * Returns a DatabaseQuery instance according to the kind of the query the
     * owning ParseTree represents: SELECT, UPDATE or DELETE.
     */ 
    public abstract DatabaseQuery createDatabaseQuery(ParseTreeContext context);

    /**
     * INTERNAL
     * Apply this node to the passed query
     */
    public abstract void applyToQuery(DatabaseQuery theQuery, GenerationContext context);

    /**
     * INTERNAL
     * Return a TopLink expression generated using the left node
     */
    public abstract Expression generateExpression(GenerationContext context);


  /**
   * Compute the Reference class for this query 
   * @param context 
   * @return the class this query is querying for
   */
    public Class getReferenceClass(GenerationContext genContext) {
        return resolveClass(genContext);
    }

    public boolean isSelectNode() {
        return false;
    }

    public boolean isUpdateNode() {
        return false;
    }

    public boolean isDeleteNode() {
        return false;
    }

    /**
     * Return the class represented in this node.
     */
    public abstract Class resolveClass(GenerationContext context);

    /**
     * Set the parseTree
     */
    public void setParseTree(ParseTree parseTree) {
        this.parseTree = parseTree;
    }

    /** */
    public ParseTree getParseTree() {
        return parseTree;
    }
    
}
