/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.exceptions.i18n;


/**
 * INTERNAL:
 * English ResourceBundle for TopLinkException messages.
 *
 * Creation date: (12/6/00 9:47:38 AM)
 * @author: Rick Barkhouse
 */
public class ExceptionResource extends java.util.ListResourceBundle {
    static final Object[][] contents = {
                                           { "NoExceptionTranslationForThisLocale", "(There is no English translation for this exception.) {0}" },
                                           { "ExceptionHeader", "Exception [TOPLINK-" },
                                           { "DescriptionHeader", "Exception Description: " },
                                           { "InternalExceptionHeader", "Internal Exception: " },
                                           { "TargetInvocationExceptionHeader", "Target Invocation Exception: " },
                                           { "ErrorCodeHeader", "Error Code: " },
                                           { "LocalExceptionStackHeader", "Local Exception Stack: " },
                                           { "InternalExceptionStackHeader", "Internal Exception Stack: " },
                                           { "TargetInvocationExceptionStackHeader", "Target Invocation Exception Stack: " },
                                           { "MappingHeader", "Mapping: " },
                                           { "DescriptorHeader", "Descriptor: " },
                                           { "QueryHeader", "Query: " },
                                           { "CallHeader", "Call: " },
                                           { "DescriptorExceptionsHeader", "Descriptor Exceptions: " },
                                           { "RuntimeExceptionsHeader", "Runtime Exceptions: " },
                                           { "ErrorFormattingMessage", "Error in message format: {0} Arguments: {1}" }
    };

    /**
     * Return the lookup table.
     */
    protected Object[][] getContents() {
        return contents;
    }
}
