/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries;

import java.util.List;
import java.util.ArrayList;

import javax.persistence.QueryHint;
import javax.persistence.NamedNativeQuery;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;

/**
 * Object to hold onto named native query metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataNamedNativeQuery extends MetadataQuery {
    private Class m_resultClass;
    private String m_resultSetMapping;
    
    /**
     * INTERNAL:
     */
    protected MetadataNamedNativeQuery() {}
    
    /**
     * INTERNAL:
     */
    public MetadataNamedNativeQuery(NamedNativeQuery namedNativeQuery, Class javaClass) {
        // Set the location where we found this query.
        setLocation(javaClass.getName());
        
        // Process the name
        setName(namedNativeQuery.name());
        
        // Process the query string.
        setEJBQLString(namedNativeQuery.query());
        
        // Process the query hints.
        for (QueryHint hint : namedNativeQuery.hints()) {
            addHint(new MetadataQueryHint(hint.name(), hint.value()));
        }   
        
        // Process the result class.
        setResultClass(namedNativeQuery.resultClass());
        
        // Process the result set mapping.
        setResultSetMapping(namedNativeQuery.resultSetMapping());
    }
    
    /**
     * INTERNAL:
     */
    public String getIgnoreLogMessageContext() {
        return MetadataLogger.IGNORE_NAMED_NATIVE_QUERY_ANNOTATION;
    }
    
    /**
     * INTERNAL:
     */
    public Class getResultClass() {
        return m_resultClass;
    }
    
    /**
     * INTERNAL:
     */
    public String getResultSetMapping() {
        return m_resultSetMapping;
    }
    
    /**
     * INTERNAL:
     */
    protected void setResultClass(Class resultClass) {
        m_resultClass = resultClass;
    }
    
    /**
     * INTERNAL:
     */
    protected void setResultSetMapping(String resultSetMapping) {
        m_resultSetMapping = resultSetMapping;
    }
}
