/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import oracle.toplink.essentials.descriptors.DescriptorQueryManager;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;

public class DeleteObjectQuery
extends WriteObjectQuery {
    public DeleteObjectQuery() {
    }

    public DeleteObjectQuery(Object objectToDelete) {
        this();
        this.setObject(objectToDelete);
    }

    public DeleteObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        this.checkDescriptor(session);
        DescriptorQueryManager queryManager = this.getDescriptor().getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && queryManager.hasDeleteQuery()) {
            return queryManager.getDeleteQuery();
        }
        return null;
    }

    public void executeCommit() throws DatabaseException {
        if (this.getObject() != null) {
            this.getQueryMechanism().deleteObjectForWrite();
        }
    }

    protected Object executeInUnitOfWorkObjectLevelModifyQuery(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        Object result = unitOfWork.processDeleteObjectQuery(this);
        if (result != null) {
            return result;
        }
        return super.executeInUnitOfWorkObjectLevelModifyQuery(unitOfWork, translationRow);
    }

    public void executeShallowWrite() {
        this.getQueryMechanism().shallowDeleteObjectForWrite(this.getObject(), this, this.getSession().getCommitManager());
    }

    public boolean isDeleteObjectQuery() {
        return true;
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareDeleteObject();
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        DeleteObjectQuery customDeleteQuery = (DeleteObjectQuery)customQuery;
        customDeleteQuery.setObject(this.getObject());
        customDeleteQuery.setObjectChangeSet(this.getObjectChangeSet());
        customDeleteQuery.setCascadePolicy(this.getCascadePolicy());
        customDeleteQuery.setShouldMaintainCache(this.shouldMaintainCache());
        customDeleteQuery.setTranslationRow(customDeleteQuery.getDescriptor().getObjectBuilder().buildRow(this.getObject(), customDeleteQuery.getSession()));
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().addLockValuesToTranslationRow(this);
        }
    }
}

