/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.expressions.SQLModifyStatement;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;

public class SQLInsertStatement
extends SQLModifyStatement {
    protected SQLCall buildCallWithoutReturning(AbstractSession session) {
        SQLCall call = new SQLCall();
        call.returnNothing();
        CharArrayWriter writer = new CharArrayWriter(200);
        try {
            int i;
            DatabaseField field;
            writer.write("INSERT ");
            writer.write("INTO ");
            writer.write(this.getTable().getQualifiedName());
            writer.write(" (");
            Vector<DatabaseField> fieldsForTable = new Vector<DatabaseField>();
            Enumeration fieldsEnum = this.getModifyRow().keys();
            while (fieldsEnum.hasMoreElements()) {
                field = (DatabaseField)fieldsEnum.nextElement();
                if (!field.getTable().equals(this.getTable()) && field.hasTableName()) continue;
                fieldsForTable.addElement(field);
            }
            if (fieldsForTable.isEmpty()) {
                throw QueryException.objectToInsertIsEmpty(this.getTable());
            }
            for (i = 0; i < fieldsForTable.size(); ++i) {
                writer.write(((DatabaseField)fieldsForTable.elementAt(i)).getName());
                if (i + 1 >= fieldsForTable.size()) continue;
                writer.write(", ");
            }
            writer.write(") VALUES (");
            for (i = 0; i < fieldsForTable.size(); ++i) {
                field = (DatabaseField)fieldsForTable.elementAt(i);
                call.appendModify(writer, field);
                if (i + 1 >= fieldsForTable.size()) continue;
                writer.write(", ");
            }
            writer.write(")");
            call.setSQLString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return call;
    }
}

