/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.AegisServiceHandler;
import org.codehaus.xfire.aegis.mapping.TypeRegistry;
import org.codehaus.xfire.aegis.operation.WrappedOperation;
import org.codehaus.xfire.aegis.wsdl.AegisWSDL;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.handler.dom.DOMHandler;
import org.codehaus.xfire.handler.dom.DOMPipelineHandler;
import org.codehaus.xfire.plexus.simple.PlexusSimpleService;
import org.codehaus.xfire.wsdl.WSDLBuilder;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class AegisService
extends PlexusSimpleService
implements Initializable {
    private Document serviceDescriptor;
    private Map operations = new HashMap();
    private String serviceClassName;
    private TypeRegistry typeRegistry;
    private PlexusConfiguration[] handlers;
    private Handler serviceHandler;

    public void initialize() throws Exception {
        super.initialize();
        DOMPipelineHandler pipe = (DOMPipelineHandler)this.getServiceHandler();
        if (this.handlers != null && this.handlers.length > 0) {
            for (int i = 0; i < this.handlers.length; ++i) {
                String hId = this.handlers[i].getValue();
                DOMHandler handler = (DOMHandler)this.getServiceLocator().lookup(DOMHandler.ROLE, hId);
                pipe.getHandlers().add(handler);
            }
        } else {
            pipe.getHandlers().add(new AegisServiceHandler());
        }
        this.typeRegistry = (TypeRegistry)this.getServiceLocator().lookup(TypeRegistry.ROLE);
        this.setWSDLBuilder((WSDLBuilder)this.getServiceLocator().lookup(WSDLBuilder.ROLE, "aegis"));
        SAXReader xmlReader = new SAXReader();
        this.serviceDescriptor = xmlReader.read(this.getServiceDescriptorStream());
        this.createService();
        AegisWSDL wsdl = (AegisWSDL)this.getWSDL();
    }

    protected void createService() {
        Element root = this.serviceDescriptor.getRootElement();
        this.setDefaultNamespace(root.attribute("targetNamespace").getStringValue());
        this.setSoapVersion(root.attribute("soapVersion").getStringValue());
        if (this.getSoapVersion().equals("http://www.w3.org/2003/05/soap-envelope")) {
            this.setFaultHandlerHint("1.2");
        } else {
            this.setFaultHandlerHint("1.1");
        }
        List elements = root.elements("operation");
        Iterator itr = elements.iterator();
        while (itr.hasNext()) {
            Element opEl = (Element)itr.next();
            WrappedOperation op = new WrappedOperation();
            op.configure(opEl, this, this.getTypeRegistry());
            QName opQ = op.getQName();
            this.operations.put(opQ, op);
        }
    }

    public Collection getOperations() {
        return this.operations.values();
    }

    public WrappedOperation getOperation(QName name) {
        return (WrappedOperation)this.operations.get(name);
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public InputStream getServiceDescriptorStream() {
        String name = this.getServiceDescriptorName();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (is == null) {
            throw new XFireRuntimeException("No service descriptor found: " + name);
        }
        return is;
    }

    public String getServiceDescriptorName() {
        String full = this.getServiceClassName();
        full = "/" + full.replace('.', '/');
        return full + ".xml";
    }

    public Document getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public void setServiceClassName(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public Object createServiceObject() {
        if (this.getServiceLocator().hasComponent(this.getServiceClassName())) {
            try {
                return this.getServiceLocator().lookup(this.getServiceClassName());
            }
            catch (ComponentLookupException e) {
                throw new XFireRuntimeException("Couldn't lookup service.", (Throwable)e);
            }
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = cl.loadClass(this.getServiceClassName());
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't create service class.", (Throwable)e);
        }
    }

    public void configure(PlexusConfiguration config) throws PlexusConfigurationException {
        super.configure(config);
        this.setFaultHandlerHint(config.getChild("faultHandler").getValue("aegis"));
        this.setServiceClassName(config.getChild("serviceClass").getValue());
        this.setStyle("wrapped");
        this.setUse("literal");
        DOMPipelineHandler handler = new DOMPipelineHandler();
        this.setServiceHandler((Handler)handler);
        this.handlers = config.getChild("handlers").getChildren("handler");
    }

    public Handler getServiceHandler() {
        return this.serviceHandler;
    }

    public void setServiceHandler(Handler serviceHandler) {
        this.serviceHandler = serviceHandler;
    }
}

