/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Configurable;
import org.codehaus.xfire.AbstractXFireComponent;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.mapping.TypeRegistry;
import org.codehaus.xfire.aegis.type.Type;
import org.dom4j.QName;

public class DefaultTypeRegistry
extends AbstractXFireComponent
implements TypeRegistry,
Configurable {
    private Map types = new HashMap();

    public void register(QName typeQ, Class typeClass) {
        this.types.put(typeQ, typeClass);
    }

    public Class getTypeClass(QName typeQ) {
        return (Class)this.types.get(typeQ);
    }

    public Type createType(QName typeQ) {
        try {
            Class clazz = this.getTypeClass(typeQ);
            if (clazz == null) {
                return null;
            }
            Type type = (Type)clazz.newInstance();
            return type;
        }
        catch (InstantiationException e) {
            throw new XFireRuntimeException("Could not create type.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new XFireRuntimeException("Could not create type.", (Throwable)e);
        }
    }

    public Class unregisterType(QName typeQ) {
        return (Class)this.types.remove(typeQ);
    }

    public Collection getAllTypes() {
        return this.types.values();
    }

    public void configure(PlexusConfiguration config) throws PlexusConfigurationException {
        PlexusConfiguration[] types = config.getChildren("types");
        for (int i = 0; i < types.length; ++i) {
            String namespace = types[i].getAttribute("namespace");
            PlexusConfiguration[] type = types[i].getChildren("type");
            for (int j = 0; j < type.length; ++j) {
                this.createType(type[j], namespace);
            }
        }
    }

    private void createType(PlexusConfiguration configuration, String namespace) throws PlexusConfigurationException {
        String name = configuration.getAttribute("name");
        String className = configuration.getAttribute("type");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        QName q = QName.get((String)name, (String)namespace);
        try {
            this.register(q, cl.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            throw new PlexusConfigurationException("Couldn't configure type.", (Throwable)e);
        }
    }
}

