/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.operation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.AegisService;
import org.codehaus.xfire.aegis.mapping.TypeRegistry;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.dom.Message;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class WrappedOperation {
    private List request = new ArrayList();
    private List response = new ArrayList();
    private List requestHeader = new ArrayList();
    private List responseHeader = new ArrayList();
    private QName qName;
    private String documentation;

    public void write(Message message, Map vars) throws XFireFault {
        Iterator itr = this.responseHeader.iterator();
        while (itr.hasNext()) {
            Type type = (Type)itr.next();
            type.write(message.getHeader(), vars);
        }
        QName responseQ = QName.get((String)(this.getQName().getName() + "Response"), (Namespace)this.getQName().getNamespace());
        Element responseEl = message.getBody().addElement(responseQ);
        Iterator itr2 = this.response.iterator();
        while (itr2.hasNext()) {
            Type type = (Type)itr2.next();
            type.write(responseEl, vars);
        }
    }

    public void read(Message message, Map vars) throws XFireFault {
        Element header = message.getHeader();
        if (header != null) {
            Iterator itr = this.requestHeader.iterator();
            while (itr.hasNext()) {
                Type type = (Type)itr.next();
                type.read(message.getHeader(), vars);
            }
        }
        Element payload = (Element)message.getBody().elements().get(0);
        Iterator itr = this.request.iterator();
        while (itr.hasNext()) {
            Type type = (Type)itr.next();
            type.read(payload, vars);
        }
    }

    public void configure(Element config, AegisService service, TypeRegistry reg) {
        this.setQName(QName.get((String)config.attributeValue("name"), (String)service.getDefaultNamespace()));
        this.setDocumentation(config.getTextTrim());
        this.configureTypes(service, this.response, reg, config.element("response"));
        this.configureTypes(service, this.request, reg, config.element("request"));
        this.configureTypes(service, this.responseHeader, reg, config.element("responseHeader"));
        this.configureTypes(service, this.requestHeader, reg, config.element("requestHeader"));
    }

    private void configureTypes(AegisService service, List types, TypeRegistry reg, Element resEl) {
        if (resEl == null) {
            return;
        }
        List resElements = resEl.elements();
        Iterator itr = resElements.iterator();
        while (itr.hasNext()) {
            Element paramEl = (Element)itr.next();
            Type type = this.createType(service, reg, paramEl);
            types.add(type);
        }
    }

    private Type createType(AegisService service, TypeRegistry reg, Element paramEl) {
        QName typeQ = QName.get((String)paramEl.getName(), (String)service.getSoapVersion());
        Type type = reg.createType(typeQ);
        if (type == null) {
            throw new XFireRuntimeException("No such type exists: " + typeQ);
        }
        type.configure(paramEl, service, reg);
        return type;
    }

    public List getRequest() {
        return this.request;
    }

    public void setRequest(List request) {
        this.request = request;
    }

    public List getResponse() {
        return this.response;
    }

    public void setResponse(List response) {
        this.response = response;
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName name) {
        this.qName = name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
}

