/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.AegisService;
import org.codehaus.xfire.aegis.mapping.TypeRegistry;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.NamespaceHelper;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ArrayType
extends Type {
    private String key;
    private String arrayClass;
    private Type childType;
    private String postOgnl;

    public void write(Element element, Map context) throws XFireFault {
        try {
            Object value = null;
            try {
                value = Ognl.getValue((String)this.getOgnl(), (Map)context, (Object)null);
            }
            catch (NullPointerException e) {
                return;
            }
            if (value == null) {
                return;
            }
            Element typeEl = element.addElement(this.getQName());
            if (value instanceof Object[]) {
                Object[] children = (Object[])value;
                for (int i = 0; i < children.length; ++i) {
                    context.put(this.getKey(), children[i]);
                    Type type = this.getChildType();
                    type.write(typeEl, context);
                }
            } else if (value instanceof Collection) {
                Collection children = (Collection)value;
                Iterator itr = children.iterator();
                while (itr.hasNext()) {
                    context.put(this.getKey(), itr.next());
                    Type type = this.getChildType();
                    type.write(typeEl, context);
                }
            }
            context.put(this.getKey(), null);
        }
        catch (OgnlException e) {
            throw new XFireFault("Couldn't process message.", (Exception)((Object)e), "Sender");
        }
    }

    public void read(Element element, Map context) throws XFireFault {
        this.read(element, 0, context);
    }

    public void read(Element root, int occurrence, Map context) throws XFireFault {
        List elements = root.elements(this.getQName());
        if (elements.size() <= occurrence) {
            return;
        }
        Element element = (Element)elements.get(occurrence);
        int size = element.elements().size();
        ArrayList<Object> array = new ArrayList<Object>(size);
        context.put(this.getKey() + ".length", new Integer(size));
        for (int i = 0; i < size; ++i) {
            context.put(this.getKey() + ".index", new Integer(i));
            this.getChildType().read(element, i, context);
            try {
                Object value = Ognl.getValue((String)this.getOgnl(), (Map)context, (Object)null);
                array.add(value);
            }
            catch (OgnlException e) {
                throw new XFireFault("Couldn't process message.", (Exception)((Object)e), "Sender");
            }
            ++i;
        }
        if (array.size() > 0) {
            context.put(this.getKey(), array);
            if (this.getPostOgnl() != null) {
                try {
                    Ognl.getValue((String)this.getPostOgnl(), (Map)context, array);
                }
                catch (OgnlException e) {
                    throw new XFireFault("Couldn't process message.", (Exception)((Object)e), "Sender");
                }
            }
        }
    }

    public boolean isComplex() {
        return true;
    }

    public Set getDependencies() {
        HashSet<Type> deps = new HashSet<Type>();
        deps.add(this.getChildType());
        return deps;
    }

    public Type getChildType() {
        return this.childType;
    }

    public void setChildType(Type childType) {
        this.childType = childType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getPostOgnl() {
        return this.postOgnl;
    }

    public void setPostOgnl(String postOgnl) {
        this.postOgnl = postOgnl;
    }

    public void writeSchema(Element root) {
        Namespace xsdNs = root.getNamespaceForURI("http://www.w3.org/2001/XMLSchema");
        Namespace arrayNs = root.getNamespaceForURI(this.getSchemaType().getNamespaceURI());
        QName elementQ = new QName("element", xsdNs);
        Element concreteEl = root.addElement(elementQ);
        concreteEl.addAttribute("name", this.getName());
        QName complexQ = new QName("complexType", xsdNs);
        Element complex = concreteEl.addElement(complexQ);
        QName seqQ = new QName("sequence", xsdNs);
        Element seq = complex.addElement(seqQ);
        Type type = this.getChildType();
        Element element = seq.addElement(elementQ);
        Namespace typeNS = root.getNamespaceForURI(type.getSchemaType().getNamespaceURI());
        if (type.isComplex()) {
            element.addAttribute("ref", typeNS.getPrefix() + ":" + type.getSchemaType().getName());
        } else {
            element.addAttribute("name", type.getName());
            element.addAttribute("type", typeNS.getPrefix() + ":" + type.getSchemaType().getName());
            element.addAttribute("nillable", "true");
        }
        element.addAttribute("minOccurs", "0");
        element.addAttribute("maxOccurs", "unbounded");
    }

    public void configure(Element configuration, AegisService service, TypeRegistry reg) {
        this.setName(configuration.attributeValue("name"));
        this.setOgnl(configuration.attributeValue("ognl"));
        this.setPostOgnl(configuration.attributeValue("postOgnl"));
        this.setKey(configuration.attributeValue("key"));
        this.setDocumentation(configuration.getTextTrim());
        this.setQName(QName.get((String)this.getName(), (String)service.getDefaultNamespace()));
        Attribute xsdAt = configuration.attribute("schemaType");
        if (xsdAt != null) {
            this.setSchemaType(null);
        } else {
            Namespace ns = NamespaceHelper.getNamespace((Element)configuration, (String)service.getDefaultNamespace());
            this.setSchemaType(new QName(this.getName(), ns));
        }
        if (configuration.elements().size() > 1) {
            throw new XFireRuntimeException("Only one array child type allowed.");
        }
        Element childTypeEl = (Element)configuration.elements().get(0);
        QName typeQ = QName.get((String)childTypeEl.getName(), (String)service.getSoapVersion());
        Type type = reg.createType(typeQ);
        type.configure(childTypeEl, service, reg);
        this.setChildType(type);
    }
}

