/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlException;
import org.codehaus.xfire.aegis.AegisService;
import org.codehaus.xfire.aegis.mapping.TypeRegistry;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class BeanType
extends Type {
    private List children;
    private String key;

    public void write(Element element, Map context) throws XFireFault {
        if (this.getKey() == null || context.containsKey(this.getKey())) {
            Element typeEl = element.addElement(this.getQName());
            if (this.getChildren() != null) {
                Iterator itr = this.getChildren().iterator();
                while (itr.hasNext()) {
                    Type type = (Type)itr.next();
                    type.write(typeEl, context);
                }
            }
        }
    }

    public void read(Element element, Map context) throws XFireFault {
        this.read(element, 0, context);
    }

    public void read(Element element, int occurrence, Map context) throws XFireFault {
        List elements = element.elements(this.getQName());
        if (elements == null || elements.size() <= occurrence) {
            return;
        }
        Element typeEl = (Element)elements.get(occurrence);
        if (this.getOgnl() != null) {
            try {
                Object value = Ognl.getValue((String)this.getOgnl(), (Map)context, (Object)null);
                context.put(this.key, value);
            }
            catch (OgnlException e) {
                throw new XFireFault("Couldn't process message.", (Exception)((Object)e), "Sender");
            }
        }
        if (this.getChildren() != null) {
            Iterator itr = this.getChildren().iterator();
            while (itr.hasNext()) {
                Type type = (Type)itr.next();
                type.read(typeEl, context);
            }
        }
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public void addChild(Type type) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(type);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isComplex() {
        return true;
    }

    public void writeSchema(Element root) {
        Namespace xsdNs = root.getNamespaceForURI("http://www.w3.org/2001/XMLSchema");
        Namespace beanNs = root.getNamespaceForURI(this.getSchemaType().getNamespaceURI());
        QName elementQ = new QName("element", xsdNs);
        Element concreteEl = root.addElement(elementQ);
        concreteEl.addAttribute("name", this.getName());
        QName complexQ = new QName("complexType", xsdNs);
        Element complex = concreteEl.addElement(complexQ);
        QName seqQ = new QName("sequence", xsdNs);
        Element seq = complex.addElement(seqQ);
        if (this.getChildren() == null) {
            return;
        }
        Iterator itr = this.getChildren().iterator();
        while (itr.hasNext()) {
            Type type = (Type)itr.next();
            Element element = seq.addElement(elementQ);
            Namespace typeNS = root.getNamespaceForURI(type.getSchemaType().getNamespaceURI());
            if (type.isComplex()) {
                element.addAttribute("ref", typeNS.getPrefix() + ":" + type.getSchemaType().getName());
                continue;
            }
            element.addAttribute("name", type.getName());
            element.addAttribute("nillable", "true");
            element.addAttribute("type", typeNS.getPrefix() + ":" + type.getSchemaType().getName());
        }
    }

    public void configure(Element configuration, AegisService service, TypeRegistry reg) {
        String max;
        this.setName(configuration.attributeValue("name"));
        this.setOgnl(configuration.attributeValue("ognl"));
        this.setKey(configuration.attributeValue("key"));
        String min = configuration.attributeValue("minOccurs");
        if (min != null) {
            this.setMinOccurs(min);
        }
        if ((max = configuration.attributeValue("maxOccurs")) != null) {
            this.setMaxOccurs(max);
        }
        this.setQName(QName.get((String)this.getName(), (String)service.getDefaultNamespace()));
        this.setDocumentation(configuration.getTextTrim());
        Attribute xsdAt = configuration.attribute("schemaType");
        if (xsdAt != null) {
            this.setSchemaType(null);
        } else {
            this.setSchemaType(QName.get((String)this.getName(), (String)service.getDefaultNamespace()));
        }
        List childElements = configuration.elements();
        Iterator itr = childElements.iterator();
        while (itr.hasNext()) {
            Element paramEl = (Element)itr.next();
            QName typeQ = QName.get((String)paramEl.getName(), (String)service.getSoapVersion());
            Type type = reg.createType(typeQ);
            if (type == null) {
                throw new RuntimeException("No such type: " + typeQ.getName());
            }
            type.configure(paramEl, service, reg);
            this.addChild(type);
        }
    }

    public Set getDependencies() {
        if (this.children == null) {
            return null;
        }
        HashSet deps = new HashSet();
        deps.addAll(this.children);
        return deps;
    }
}

