/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.AegisService;
import org.codehaus.xfire.aegis.mapping.TypeRegistry;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.dom4j.Element;
import org.dom4j.QName;

public class FlatArrayType
extends Type {
    private String key;
    private String arrayClass;
    private Type childType;

    public void write(Element element, Map context) throws XFireFault {
        try {
            Object value = Ognl.getValue((String)this.getOgnl(), (Map)context, (Object)null);
            if (value == null) {
                return;
            }
            if (value instanceof Object[]) {
                Object[] children = (Object[])value;
                for (int i = 0; i < children.length; ++i) {
                    context.put(this.getKey(), children[i]);
                    Type type = this.getChildType();
                    type.write(element, context);
                }
            } else if (value instanceof Collection) {
                Collection children = (Collection)value;
                Iterator itr = children.iterator();
                while (itr.hasNext()) {
                    context.put(this.getKey(), itr.next());
                    Type type = this.getChildType();
                    type.write(element, context);
                }
            }
            context.put(this.getKey(), null);
        }
        catch (OgnlException e) {
            throw new XFireFault("Couldn't process message.", (Exception)((Object)e), "Sender");
        }
    }

    public void read(Element element, Map context) throws XFireFault {
        this.read(element, 0, context);
    }

    public void read(Element element, int occurrence, Map context) throws XFireFault {
        ArrayList<Object> array = new ArrayList<Object>();
        List elements = element.elements();
        context.put(this.getKey() + ".length", new Integer(elements.size()));
        int i = 0;
        Iterator itr = elements.iterator();
        while (itr.hasNext()) {
            context.put(this.getKey() + ".index", new Integer(i));
            Element arrayEl = (Element)itr.next();
            this.getChildType().read(arrayEl, context);
            try {
                Object value = Ognl.getValue((String)this.getOgnl(), (Map)context, (Object)null);
                array.add(value);
            }
            catch (OgnlException e) {
                throw new XFireFault("Couldn't process message.", (Exception)((Object)e), "Sender");
            }
            ++i;
        }
        context.put(this.getKey(), array);
    }

    public boolean isComplex() {
        return this.getChildType().isComplex();
    }

    public Set getDependencies() {
        return this.getChildType().getDependencies();
    }

    public Type getChildType() {
        return this.childType;
    }

    public void setChildType(Type childType) {
        this.childType = childType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void writeSchema(Element root) {
        this.getChildType().writeSchema(root);
    }

    public String getMaxOccurs() {
        return this.getChildType().getMaxOccurs();
    }

    public String getMinOccurs() {
        return this.getChildType().getMinOccurs();
    }

    public String getName() {
        return this.getChildType().getName();
    }

    public QName getQName() {
        return this.getChildType().getQName();
    }

    public QName getSchemaType() {
        return this.getChildType().getSchemaType();
    }

    public void configure(Element configuration, AegisService service, TypeRegistry reg) {
        this.setOgnl(configuration.attributeValue("ognl"));
        this.setKey(configuration.attributeValue("key"));
        this.setDocumentation(configuration.getTextTrim());
        if (configuration.elements().size() > 1) {
            throw new XFireRuntimeException("Only one array child type allowed.");
        }
        Element childTypeEl = (Element)configuration.elements().get(0);
        QName typeQ = QName.get((String)childTypeEl.getName(), (String)service.getSoapVersion());
        Type type = reg.createType(typeQ);
        type.configure(childTypeEl, service, reg);
        this.setChildType(type);
    }
}

