/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.wsdl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.codehaus.xfire.aegis.AegisService;
import org.codehaus.xfire.aegis.operation.WrappedOperation;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.wsdl.AbstractWSDL;
import org.codehaus.xfire.wsdl.WSDL;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;

public class AegisWSDL
extends AbstractWSDL
implements WSDL {
    private Set transports;
    private Map wsdlOps;

    public AegisWSDL(AegisService service, Set transports) throws WSDLException {
        super((Service)service);
        this.transports = transports;
        this.wsdlOps = new HashMap();
        Document descriptor = service.getServiceDescriptor();
        Element userTypes = descriptor.getRootElement().element("types");
        if (userTypes != null) {
            this.addUserTypes(userTypes);
        }
        PortType portType = this.createAbstractInterface();
        this.createConcreteInterface(portType);
        this.writeDocument();
    }

    private void addUserTypes(Element element) {
        Iterator itr = element.elementIterator();
        while (itr.hasNext()) {
            Element typeEl = (Element)itr.next();
            String name = typeEl.attributeValue("name");
            int index = name.indexOf(":");
            String prefix = name.substring(0, index);
            String typeName = name.substring(index + 1);
            Namespace ns = element.getNamespaceForPrefix(prefix);
            Element newType = this.createSchemaType(ns.getURI());
            newType.add(ns);
            int size = typeEl.elements().size();
            for (int i = 0; i < size; ++i) {
                Element te = (Element)typeEl.elements().get(0);
                Node n = te.detach();
                newType.add(n);
            }
        }
    }

    protected PortType createAbstractInterface() {
        AegisService service = (AegisService)this.getService();
        QName portName = new QName(service.getDefaultNamespace(), service.getName() + "PortType");
        Definition def = this.getDefinition();
        PortType portType = def.createPortType();
        portType.setQName(portName);
        portType.setUndefined(false);
        def.addPortType(portType);
        Iterator itr = service.getOperations().iterator();
        while (itr.hasNext()) {
            WrappedOperation op = (WrappedOperation)itr.next();
            Message req = this.getInputMessage(op);
            def.addMessage(req);
            Message res = this.getOutputMessage(op);
            def.addMessage(res);
            String opName = op.getQName().getName();
            Operation wsdlOp = this.createOperation(opName, req, res);
            wsdlOp.setUndefined(false);
            portType.addOperation(wsdlOp);
            this.wsdlOps.put(opName, wsdlOp);
        }
        return portType;
    }

    protected void createConcreteInterface(PortType portType) {
        AegisService service = (AegisService)this.getService();
        QName name = new QName(service.getDefaultNamespace(), service.getName());
        javax.wsdl.Service wsdlService = this.getDefinition().createService();
        wsdlService.setQName(name);
        Iterator itr = this.transports.iterator();
        while (itr.hasNext()) {
            Transport transport = (Transport)itr.next();
            Binding transportBinding = transport.createBinding(portType, (Service)service);
            Iterator oitr = service.getOperations().iterator();
            while (oitr.hasNext()) {
                WrappedOperation op = (WrappedOperation)oitr.next();
                Operation wsdlOp = (Operation)this.wsdlOps.get(op.getQName().getName());
                BindingOperation bop = transport.createBindingOperation(portType, wsdlOp, (Service)service);
                transportBinding.addBindingOperation(bop);
            }
            Port transportPort = transport.createPort(transportBinding, (Service)service);
            this.getDefinition().addBinding(transportBinding);
            wsdlService.addPort(transportPort);
        }
        this.getDefinition().addService(wsdlService);
    }

    protected Operation createOperation(String opName, Message req, Message res) {
        Definition def = this.getDefinition();
        Input input = def.createInput();
        input.setMessage(req);
        input.setName(req.getQName().getLocalPart());
        Output output = def.createOutput();
        output.setMessage(res);
        output.setName(res.getQName().getLocalPart());
        Operation wsdlOp = def.createOperation();
        wsdlOp.setName(opName);
        wsdlOp.setInput(input);
        wsdlOp.setOutput(output);
        return wsdlOp;
    }

    private Message getOutputMessage(WrappedOperation op) {
        Message res = this.getDefinition().createMessage();
        res.setQName(new QName(this.getService().getDefaultNamespace(), op.getQName().getName() + "Response"));
        res.setUndefined(false);
        this.createOutputParts(res, op);
        return res;
    }

    private Message getInputMessage(WrappedOperation op) {
        Message req = this.getDefinition().createMessage();
        req.setQName(new QName(this.getService().getDefaultNamespace(), op.getQName().getName() + "Request"));
        req.setUndefined(false);
        this.createInputParts(req, op);
        return req;
    }

    private QName createResponseSchemaType(WrappedOperation op, Part part) {
        String opName = op.getQName().getName() + "Response";
        QName qName = new QName(this.getService().getDefaultNamespace(), opName);
        Element root = this.createSchemaType(qName.getNamespaceURI());
        this.createParameterTypes(op.getResponse(), opName, root);
        return qName;
    }

    private QName createRequestSchemaType(WrappedOperation op, Part part) {
        String opName = op.getQName().getName();
        QName qName = new QName(this.getService().getDefaultNamespace(), opName);
        Element root = this.createSchemaType(qName.getNamespaceURI());
        this.createParameterTypes(op.getRequest(), opName, root);
        return qName;
    }

    private void createParameterTypes(List operations, String opName, Element root) {
        Element element = root.addElement(this.elementQ);
        element.addAttribute("name", opName);
        org.dom4j.QName complexQ = new org.dom4j.QName("complexType", this.xsdNs);
        Element complex = element.addElement(complexQ);
        if (operations.size() > 0) {
            Element sequence = this.createSequence(complex);
            Iterator itr = operations.iterator();
            while (itr.hasNext()) {
                Type type = (Type)itr.next();
                Namespace typeNS = this.getNamespace(type.getSchemaType().getNamespaceURI());
                org.dom4j.QName outElementQ = new org.dom4j.QName("element", this.xsdNs);
                Element outElement = sequence.addElement(outElementQ);
                if (type.isComplex()) {
                    outElement.addAttribute("ref", typeNS.getPrefix() + ":" + type.getSchemaType().getName());
                } else {
                    outElement.addAttribute("name", type.getName());
                    outElement.addAttribute("type", typeNS.getPrefix() + ":" + type.getSchemaType().getName());
                }
                outElement.addAttribute("minOccurs", type.getMinOccurs());
                outElement.addAttribute("maxOccurs", type.getMaxOccurs());
                this.addDependency(type);
            }
        }
    }

    private Element createSequence(Element complex) {
        org.dom4j.QName sequenceQ = new org.dom4j.QName("sequence", this.xsdNs);
        return complex.addElement(sequenceQ);
    }

    protected void createInputParts(Message req, WrappedOperation op) {
        Part part = this.getDefinition().createPart();
        QName typeQName = this.createRequestSchemaType(op, part);
        part.setName("parameters");
        part.setElementName(typeQName);
        req.addPart(part);
    }

    protected void createOutputParts(Message req, WrappedOperation op) {
        Part part = this.getDefinition().createPart();
        QName typeQName = this.createResponseSchemaType(op, part);
        part.setElementName(typeQName);
        part.setName("parameters");
        req.addPart(part);
    }
}

