/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.lambda;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Arn {
    private static final List<Pattern> PATTERN_ARNS = Arrays.asList(Pattern.compile("^arn:(?<partition>[\\w\\-]):(?<service>[\\w\\-]):(?<region>[\\w\\-]):(?<accountId>[\\w\\-]):(?<resource>[\\w\\-])"), Pattern.compile("^arn:(?<partition>[\\w\\-]):(?<service>[\\w\\-]):(?<region>[\\w\\-]):(?<accountId>[\\w\\-]):(?<resourceType>[\\w\\-]):(?<resource>[\\w\\-])"), Pattern.compile("^arn:(?<partition>[\\w\\-]):(?<service>[\\w\\-]):(?<region>[\\w\\-]):(?<accountId>[\\w\\-]):(?<resourceType>[\\w\\-])/(?<resource>[\\w\\-])"));
    String sourceArn;
    String partition;
    String service;
    String region;
    String accountId;
    String resource;
    String resourceType;

    public Arn(String sourceArn, String partition, String service, String region, String accountId, String resource, String resourceType) {
        this.sourceArn = sourceArn;
        this.partition = partition;
        this.service = service;
        this.region = region;
        this.accountId = accountId;
        this.resource = resource;
        this.resourceType = resourceType;
    }

    public String getSourceArn() {
        return this.sourceArn;
    }

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public static Arn lookupArn(String str) {
        for (Pattern p : PATTERN_ARNS) {
            Matcher m = p.matcher(str);
            if (!m.matches()) continue;
            String partition = m.group("partition");
            String service = m.group("service");
            String region = m.group("region");
            String accountId = m.group("accountId");
            String resource = m.group("resource");
            String resourceType = m.group("resourceType");
            return new Arn(str, partition, service, region, accountId, resource, resourceType);
        }
        return null;
    }
}

