/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.lambda;

import br.com.ingenieux.mojo.aws.util.RoleResolver;
import br.com.ingenieux.mojo.lambda.AbstractLambdaMojo;
import br.com.ingenieux.mojo.lambda.Arn;
import br.com.ingenieux.mojo.lambda.LambdaFunctionDefinition;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient;
import com.amazonaws.services.lambda.AWSLambdaClient;
import com.amazonaws.services.lambda.model.CreateAliasRequest;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.model.ResourceConflictException;
import com.amazonaws.services.lambda.model.ResourceNotFoundException;
import com.amazonaws.services.lambda.model.Runtime;
import com.amazonaws.services.lambda.model.UpdateAliasRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.VpcConfig;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="deploy-functions")
public class DeployMojo
extends AbstractLambdaMojo {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    @Parameter(required=true, property="lambda.s3url", defaultValue="${beanstalk.lastUploadedS3Object}")
    String s3Url;
    @Parameter(required=true, property="lambda.default.timeout", defaultValue="5")
    Integer defaultTimeout;
    @Parameter(required=true, property="lambda.default.memorySize", defaultValue="128")
    Integer defaultMemorySize;
    @Parameter(required=true, property="lambda.default.role", defaultValue="arn:aws:iam::*:role/lambda_basic_execution")
    String defaultRole;
    @Parameter(property="lambda.deploy.publish", defaultValue="false")
    Boolean deployPublish;
    @Parameter(property="lambda.deploy.aliases", defaultValue="false")
    Boolean deployAliases;
    @Parameter(required=true, property="lambda.definition.file", defaultValue="${project.build.outputDirectory}/META-INF/lambda-definitions.json")
    File definitionFile;
    @Parameter(property="lambda.deploy.securityGroupIds", defaultValue="")
    List<String> securityGroupIds = new ArrayList<String>();
    @Parameter(property="lambda.deploy.subnetIds", defaultValue="")
    List<String> subnetIds;
    private AWSLambdaClient lambdaClient;
    private AmazonS3URI s3Uri;
    private RoleResolver roleResolver;

    public void setSecurityGroupIds(String securityGroupIds) {
        List<String> securityGroupIdsAsList = Arrays.asList(securityGroupIds.split(","));
        this.securityGroupIds.addAll(securityGroupIdsAsList);
    }

    public void setSubnetIds(String subnetIds) {
        List<String> subnetIdsAsList = Arrays.asList(subnetIds.split(","));
        this.subnetIds.addAll(subnetIdsAsList);
    }

    protected void configure() {
        super.configure();
        try {
            this.configureInternal();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private void configureInternal() throws MojoExecutionException {
        this.lambdaClient = (AWSLambdaClient)this.getService();
        this.roleResolver = new RoleResolver((AmazonIdentityManagement)this.createServiceFor(AmazonIdentityManagementClient.class));
        this.s3Uri = new AmazonS3URI(this.s3Url);
        this.defaultRole = this.roleResolver.lookupRoleGlob(this.defaultRole);
    }

    protected Object executeInternal() throws Exception {
        Map<String, LambdaFunctionDefinition> functionDefinitions = this.parseFunctionDefinions();
        String s3Bucket = this.s3Uri.getBucket();
        String s3Key = this.s3Uri.getKey();
        for (LambdaFunctionDefinition d : functionDefinitions.values()) {
            this.getLog().info((CharSequence)String.format("Deploying Function: %s (handler: %s)", d.getName(), d.getHandler()));
            String version = null;
            try {
                UpdateFunctionCodeRequest updateFunctionCodeRequest = new UpdateFunctionCodeRequest().withFunctionName(d.getName()).withS3Bucket(s3Bucket).withPublish(this.deployPublish).withS3Key(s3Key);
                UpdateFunctionCodeResult updateFunctionCodeResult = this.lambdaClient.updateFunctionCode(updateFunctionCodeRequest);
                d.setArn(updateFunctionCodeResult.getFunctionArn());
                version = updateFunctionCodeResult.getVersion();
                d.setVersion(version);
                this.updateIfNeeded(d, updateFunctionCodeResult);
            }
            catch (ResourceNotFoundException exc) {
                this.getLog().info((CharSequence)"Function does not exist. Creating it instead.");
                CreateFunctionResult function = this.createFunction(d);
                d.setArn(function.getFunctionArn());
                version = function.getVersion();
                d.setVersion(version);
            }
            if (StringUtils.isNotBlank((String)d.getAlias()) && this.deployAliases.booleanValue()) {
                this.updateAlias(d.getName(), version, d.getAlias());
            }
            try {
                if (null == d.getBindings() || d.getBindings().isEmpty()) continue;
                this.deployBindings(d);
            }
            catch (Exception exc) {
                this.getLog().warn((CharSequence)"Failure. Skipping. ", (Throwable)exc);
            }
        }
        return functionDefinitions;
    }

    private void deployBindings(LambdaFunctionDefinition d) throws Exception {
        for (String binding : d.getBindings()) {
            Arn arn = Arn.lookupArn(binding);
            if (StringUtils.isNotBlank((String)d.getAlias())) {
                arn = Arn.lookupArn(d.getAlias());
            }
            if (null == arn) {
                this.getLog().warn((CharSequence)("Unable to find binding for arn: " + arn));
                continue;
            }
            switch (arn.getService()) {
                case "sns": {
                    this.updateSNSFunction(arn, d);
                    break;
                }
                case "dynamodb": {
                    this.updateDynamoDBFunction(arn, d);
                    break;
                }
                case "kinesis": {
                    this.updateKinesisFunction(arn, d);
                    break;
                }
                case "cognito": {
                    this.updateCognitoFunction(arn, d);
                    break;
                }
                case "s3": {
                    this.updateS3Function(arn, d);
                }
            }
        }
    }

    private void updateS3Function(Arn bindingArn, LambdaFunctionDefinition d) throws Exception {
        throw new NotImplementedException("We don't support S3 yet. Sorry. :/");
    }

    private void updateCognitoFunction(Arn bindingArn, LambdaFunctionDefinition d) throws Exception {
        throw new NotImplementedException("We don't support Cognito yet. Sorry. :/");
    }

    private void updateKinesisFunction(Arn bindingArn, LambdaFunctionDefinition d) throws Exception {
        throw new NotImplementedException("AWS SDK for Java doesn't support Kinesis Streams yet. Sorry. :/");
    }

    private void updateDynamoDBFunction(Arn bindingArn, LambdaFunctionDefinition d) throws Exception {
        throw new NotImplementedException("AWS SDK for Java doesn't support DynamoDB Streams yet. Sorry. :/");
    }

    private void updateSNSFunction(Arn bindingArn, LambdaFunctionDefinition d) throws Exception {
        AmazonSNSClient client = (AmazonSNSClient)this.createServiceFor(AmazonSNSClient.class);
        client.setRegion(Region.getRegion((Regions)Regions.fromName((String)bindingArn.getRegion())));
        SubscribeRequest req = new SubscribeRequest().withTopicArn(bindingArn.getSourceArn()).withProtocol("lambda").withEndpoint(d.getArn());
        SubscribeResult subscribe = client.subscribe(req);
        this.getLog().info((CharSequence)("Subscribed topic arn " + bindingArn.getSourceArn() + " to function " + d.getArn()));
    }

    protected Object updateAlias(String functionName, String version, String alias) {
        try {
            CreateAliasRequest req = new CreateAliasRequest().withFunctionName(functionName).withFunctionVersion(version).withName(alias);
            return this.lambdaClient.createAlias(req);
        }
        catch (ResourceConflictException exc) {
            UpdateAliasRequest req = new UpdateAliasRequest().withFunctionName(functionName).withFunctionVersion(version).withName(alias);
            return this.lambdaClient.updateAlias(req);
        }
    }

    private CreateFunctionResult createFunction(LambdaFunctionDefinition d) {
        CreateFunctionRequest req = new CreateFunctionRequest().withCode(new FunctionCode().withS3Bucket(this.s3Uri.getBucket()).withS3Key(this.s3Uri.getKey())).withDescription(d.getDescription()).withFunctionName(d.getName()).withHandler(d.getHandler()).withMemorySize(Integer.valueOf(d.getMemorySize())).withRole(d.getRole()).withRuntime(Runtime.Java8).withPublish(this.deployPublish).withVpcConfig(new VpcConfig().withSecurityGroupIds(this.securityGroupIds).withSubnetIds(this.subnetIds)).withTimeout(Integer.valueOf(d.getTimeout()));
        CreateFunctionResult createFunctionResult = this.lambdaClient.createFunction(req);
        return createFunctionResult;
    }

    private UpdateFunctionConfigurationResult updateIfNeeded(LambdaFunctionDefinition d, UpdateFunctionCodeResult curFc) {
        boolean bEquals;
        List returnedSecurityGroupIdsToMatch = Collections.emptyList();
        if (null != curFc.getVpcConfig() && !curFc.getVpcConfig().getSecurityGroupIds().isEmpty()) {
            returnedSecurityGroupIdsToMatch = curFc.getVpcConfig().getSecurityGroupIds();
        }
        List returnedSubnetIdsToMatch = Collections.emptyList();
        if (null != curFc.getVpcConfig() && !curFc.getVpcConfig().getSubnetIds().isEmpty()) {
            returnedSubnetIdsToMatch = curFc.getVpcConfig().getSubnetIds();
        }
        if (!(bEquals = new EqualsBuilder().append((Object)d.getDescription(), (Object)curFc.getDescription()).append((Object)d.getHandler(), (Object)curFc.getHandler()).append(d.getMemorySize(), curFc.getMemorySize().intValue()).append((Object)d.getRole(), (Object)curFc.getRole()).append(d.getTimeout(), curFc.getTimeout().intValue()).append(this.securityGroupIds, (Object)returnedSecurityGroupIdsToMatch).append(this.subnetIds, (Object)returnedSubnetIdsToMatch).isEquals())) {
            UpdateFunctionConfigurationRequest updRequest = new UpdateFunctionConfigurationRequest();
            updRequest.setFunctionName(d.getName());
            updRequest.setDescription(d.getDescription());
            updRequest.setHandler(d.getHandler());
            updRequest.setMemorySize(Integer.valueOf(d.getMemorySize()));
            updRequest.setRole(d.getRole());
            updRequest.setTimeout(Integer.valueOf(d.getTimeout()));
            VpcConfig vpcConfig = new VpcConfig().withSecurityGroupIds(this.securityGroupIds).withSubnetIds(this.subnetIds);
            updRequest.setVpcConfig(vpcConfig);
            this.getLog().info((CharSequence)String.format("Function Configuration doesn't match expected defaults. Updating it to %s.", updRequest));
            UpdateFunctionConfigurationResult result = this.lambdaClient.updateFunctionConfiguration(updRequest);
            return result;
        }
        return null;
    }

    private Map<String, LambdaFunctionDefinition> parseFunctionDefinions() throws Exception {
        String source = IOUtils.toString((InputStream)new FileInputStream(this.definitionFile));
        source = new StrSubstitutor((Map)this.session.getSystemProperties()).replace(source);
        this.getLog().info((CharSequence)String.format("Loaded and replaced definitions from file '%s'", this.definitionFile.getPath()));
        List definitionList = (List)OBJECT_MAPPER.readValue(source, (TypeReference)new TypeReference<List<LambdaFunctionDefinition>>(){});
        this.getLog().info((CharSequence)String.format("Found %d definitions: ", definitionList.size()));
        TreeMap<String, LambdaFunctionDefinition> result = new TreeMap<String, LambdaFunctionDefinition>();
        for (LambdaFunctionDefinition d : definitionList) {
            if (0 == d.getMemorySize()) {
                d.setMemorySize(this.defaultMemorySize);
            }
            if (org.codehaus.plexus.util.StringUtils.isBlank((String)d.getRole())) {
                d.setRole(this.defaultRole);
            } else {
                d.setRole(this.roleResolver.lookupRoleGlob(d.getRole()));
            }
            if (0 == d.getTimeout()) {
                d.setTimeout(this.defaultTimeout);
            }
            result.put(d.getName(), d);
        }
        source = OBJECT_MAPPER.writeValueAsString((Object)definitionList);
        this.getLog().debug((CharSequence)String.format("Parsed function definitions: %s", source));
        IOUtils.write((String)source, (OutputStream)new FileOutputStream(this.definitionFile));
        this.getLog().info((CharSequence)String.format("Merged into %d definitions: ", result.size()));
        return result;
    }
}

