/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.ImmutableAuthentication;
import org.jasig.cas.authentication.MutableAuthentication;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.handler.UnsupportedCredentialsException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class AuthenticationManagerImpl
implements AuthenticationManager,
InitializingBean {
    private final Log log = LogFactory.getLog((Class)AuthenticationManagerImpl.class);
    private AuthenticationHandler[] authenticationHandlers;
    private CredentialsToPrincipalResolver[] credentialsToPrincipalResolvers;
    private AuthenticationMetaDataPopulator[] authenticationMetaDataPopulators;

    public Authentication authenticate(Credentials credentials) throws AuthenticationException {
        int i;
        boolean foundSupported = false;
        boolean authenticated = false;
        for (int i2 = 0; i2 < this.authenticationHandlers.length; ++i2) {
            if (!this.authenticationHandlers[i2].supports(credentials)) continue;
            foundSupported = true;
            if (!this.authenticationHandlers[i2].authenticate(credentials)) {
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)("AuthenticationHandler: " + this.authenticationHandlers[i2].getClass().getName() + " failed to authenticate the user."));
                continue;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("AuthenticationHandler: " + this.authenticationHandlers[i2].getClass().getName() + " successfully authenticated the user."));
            }
            authenticated = true;
            break;
        }
        if (!authenticated) {
            if (foundSupported) {
                throw BadCredentialsAuthenticationException.ERROR;
            }
            throw UnsupportedCredentialsException.ERROR;
        }
        Authentication authentication = null;
        for (i = 0; i < this.credentialsToPrincipalResolvers.length; ++i) {
            if (!this.credentialsToPrincipalResolvers[i].supports(credentials)) continue;
            Principal principal = this.credentialsToPrincipalResolvers[i].resolvePrincipal(credentials);
            authentication = new MutableAuthentication(principal);
            break;
        }
        if (authentication == null) {
            this.log.error((Object)("CredentialsToPrincipalResolver not found for " + credentials.getClass().getName()));
            throw UnsupportedCredentialsException.ERROR;
        }
        for (i = 0; i < this.authenticationMetaDataPopulators.length; ++i) {
            authentication = this.authenticationMetaDataPopulators[i].populateAttributes(authentication, credentials);
        }
        return new ImmutableAuthentication(authentication.getPrincipal(), authentication.getAttributes());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty((Object[])this.authenticationHandlers, (String)"authenticationHandlers is a required property.");
        Assert.notEmpty((Object[])this.credentialsToPrincipalResolvers, (String)"credentialsToPrincipalResolvers is a required property.");
        if (this.authenticationMetaDataPopulators == null) {
            this.authenticationMetaDataPopulators = new AuthenticationMetaDataPopulator[0];
        }
    }

    public void setAuthenticationHandlers(AuthenticationHandler[] authenticationHandlers) {
        this.authenticationHandlers = authenticationHandlers;
    }

    public void setCredentialsToPrincipalResolvers(CredentialsToPrincipalResolver[] credentialsToPrincipalResolvers) {
        this.credentialsToPrincipalResolvers = credentialsToPrincipalResolvers;
    }

    public void setAuthenticationMetaDataPopulators(AuthenticationMetaDataPopulator[] authenticationMetaDataPopulators) {
        this.authenticationMetaDataPopulators = authenticationMetaDataPopulators;
    }
}

