/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceRegistry;
import org.jasig.cas.services.ServiceRegistryManager;

public final class DefaultServiceRegistry
implements ServiceRegistry,
ServiceRegistryManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map services = new HashMap();

    public boolean serviceExists(String serviceId) {
        return this.services.containsKey(serviceId);
    }

    public Collection getServices() {
        return this.services.values();
    }

    public void addService(RegisteredService service) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding service [" + service.getId() + "] to serviceRegistry"));
        }
        this.services.put(service.getId(), service);
    }

    public boolean deleteService(String serviceId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting service[" + serviceId + "] from Service Registry."));
        }
        return this.services.remove(serviceId) != null;
    }

    public RegisteredService getService(String serviceId) {
        RegisteredService authenticatedService = (RegisteredService)this.services.get(serviceId);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to retrieve service [" + serviceId + "] from Service Registry"));
        }
        if (authenticatedService != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Successfully retrieved service [" + serviceId + "] from Service Registry."));
        }
        return authenticatedService;
    }

    public void clear() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Clearing all entries from Service Registry");
        }
        this.services.clear();
    }
}

