/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.advice;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceRegistry;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class ServiceAllowedToProxyMethodBeforeAdvice
implements MethodBeforeAdvice,
InitializingBean {
    private Log log = LogFactory.getLog(this.getClass());
    private TicketRegistry ticketRegistry;
    private ServiceRegistry serviceRegistry;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.ticketRegistry, (String)"ticketRegistry is a required property.");
        Assert.notNull((Object)this.serviceRegistry, (String)"serviceRegistry is a required property.");
    }

    public void before(Method method, Object[] args, Object target) throws UnauthorizedServiceException {
        String serviceTicketId = (String)args[0];
        ServiceTicket serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket(serviceTicketId);
        RegisteredService authenticatedService = null;
        Iterator iter = this.serviceRegistry.getServices().iterator();
        while (iter.hasNext()) {
            RegisteredService service = (RegisteredService)iter.next();
            if ((service.getProxyUrl() == null || !service.getProxyUrl().toExternalForm().equals(serviceTicket.getService().getId())) && !service.getId().equals(serviceTicket.getService().getId())) continue;
            authenticatedService = service;
            break;
        }
        if (authenticatedService == null || !authenticatedService.isAllowedToProxy()) {
            throw new UnauthorizedServiceException("Service is not allowed to proxy.");
        }
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

