/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.springframework.util.Assert;

public abstract class AbstractTicket
implements Ticket {
    private final ExpirationPolicy expirationPolicy;
    private final String id;
    private final TicketGrantingTicket ticketGrantingTicket;
    private long lastTimeUsed;
    private int countOfUses;

    public AbstractTicket(String id, TicketGrantingTicket ticket, ExpirationPolicy expirationPolicy) {
        Assert.notNull((Object)expirationPolicy);
        Assert.notNull((Object)id);
        this.id = id;
        this.lastTimeUsed = System.currentTimeMillis();
        this.expirationPolicy = expirationPolicy;
        this.ticketGrantingTicket = ticket;
    }

    public final String getId() {
        return this.id;
    }

    public final int getCountOfUses() {
        return this.countOfUses;
    }

    public final long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public final void incrementCountOfUses() {
        ++this.countOfUses;
    }

    public final void updateLastTimeUsed() {
        this.lastTimeUsed = System.currentTimeMillis();
    }

    public final TicketGrantingTicket getGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    public final boolean isExpired() {
        return this.expirationPolicy.isExpired(this) || this.isExpiredInternal();
    }

    protected abstract boolean isExpiredInternal();

    public final boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

