/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.AbstractTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.springframework.util.Assert;

public final class ServiceTicketImpl
extends AbstractTicket
implements ServiceTicket {
    private static final long serialVersionUID = 1296808733190507408L;
    private final Service service;
    private boolean fromNewLogin;
    private boolean grantedTicketAlready;

    protected ServiceTicketImpl(String id, TicketGrantingTicket ticket, Service service, boolean fromNewLogin, ExpirationPolicy policy) {
        super(id, ticket, policy);
        Assert.notNull((Object)ticket);
        Assert.notNull((Object)service);
        this.service = service;
        this.fromNewLogin = fromNewLogin;
    }

    public boolean isFromNewLogin() {
        return this.fromNewLogin;
    }

    public void setFromNewLogin(boolean fromNewLogin) {
        this.fromNewLogin = fromNewLogin;
    }

    public Service getService() {
        return this.service;
    }

    public boolean isExpiredInternal() {
        return this.getGrantingTicket().isExpired();
    }

    public synchronized TicketGrantingTicket grantTicketGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
        if (this.grantedTicketAlready) {
            throw new IllegalStateException("TicketGrantingTicket already generated for this ServiceTicket.  Cannot grant more than one TGT for ServiceTicket");
        }
        this.grantedTicketAlready = true;
        return new TicketGrantingTicketImpl(id, this.getGrantingTicket(), authentication, expirationPolicy);
    }
}

