/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.AbstractTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.springframework.util.Assert;

public final class TicketGrantingTicketImpl
extends AbstractTicket
implements TicketGrantingTicket {
    private static final long serialVersionUID = -8673232562725683059L;
    private final Authentication authentication;
    private boolean expired = false;

    public TicketGrantingTicketImpl(String id, TicketGrantingTicket ticketGrantingTicket, Authentication authentication, ExpirationPolicy policy) {
        super(id, ticketGrantingTicket, policy);
        Assert.notNull((Object)authentication);
        this.authentication = authentication;
    }

    public TicketGrantingTicketImpl(String id, Authentication authentication, ExpirationPolicy policy) {
        this(id, null, authentication, policy);
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public synchronized ServiceTicket grantServiceTicket(String id, Service service, ExpirationPolicy expirationPolicy) {
        ServiceTicketImpl serviceTicket = new ServiceTicketImpl(id, this, service, this.getCountOfUses() == 0, expirationPolicy);
        this.incrementCountOfUses();
        return serviceTicket;
    }

    public boolean isRoot() {
        return this.getGrantingTicket() == null;
    }

    public void expire() {
        this.expired = true;
    }

    public boolean isExpiredInternal() {
        return this.expired || this.getGrantingTicket() != null && this.getGrantingTicket().isExpired();
    }

    public List getChainedAuthentications() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        if (this.getGrantingTicket() == null) {
            list.add(this.getAuthentication());
            return Collections.unmodifiableList(list);
        }
        list.add(this.getAuthentication());
        list.addAll(this.getGrantingTicket().getChainedAuthentications());
        return Collections.unmodifiableList(list);
    }
}

