/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.AbstractTicketRegistry;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class EhCacheTicketRegistry
extends AbstractTicketRegistry
implements InitializingBean {
    private Cache cache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void addTicket(Ticket ticket) {
        Assert.notNull((Object)ticket);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Added ticket [" + ticket.getId() + "] to registry."));
        }
        this.cache.put(new Element((Serializable)((Object)ticket.getId()), (Serializable)ticket));
    }

    public Ticket getTicket(String ticketId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to retrieve ticket [" + ticketId + "]"));
        }
        if (ticketId == null) {
            return null;
        }
        try {
            Element element = this.cache.get((Serializable)((Object)ticketId));
            if (element == null) {
                return null;
            }
            Ticket ticket = (Ticket)element.getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ticket [" + ticketId + "] found in registry."));
            }
            return ticket;
        }
        catch (Exception ex) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(ex);
            throw ise;
        }
    }

    public boolean deleteTicket(String ticketId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing ticket [" + ticketId + "] from registry"));
        }
        return this.cache.remove((Serializable)((Object)ticketId));
    }

    public Collection getTickets() {
        try {
            List keys = this.cache.getKeys();
            ArrayList<Serializable> items = new ArrayList<Serializable>();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Serializable key = (Serializable)iter.next();
                Element element = this.cache.get(key);
                items.add(element.getValue());
            }
            return Collections.unmodifiableCollection(items);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache cannot be null.");
    }
}

