/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import org.jasig.cas.util.DefaultLongNumericGenerator;
import org.jasig.cas.util.DefaultRandomStringGenerator;
import org.jasig.cas.util.NumericGenerator;
import org.jasig.cas.util.RandomStringGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;

public final class DefaultUniqueTicketIdGenerator
implements UniqueTicketIdGenerator {
    private final NumericGenerator numericGenerator = new DefaultLongNumericGenerator(1L);
    private final RandomStringGenerator randomStringGenerator;
    private String suffix;

    public DefaultUniqueTicketIdGenerator() {
        this.randomStringGenerator = new DefaultRandomStringGenerator();
    }

    public DefaultUniqueTicketIdGenerator(int maxLength) {
        this.randomStringGenerator = new DefaultRandomStringGenerator(maxLength);
    }

    public DefaultUniqueTicketIdGenerator(String suffix) {
        this();
        this.suffix = suffix;
    }

    public DefaultUniqueTicketIdGenerator(int maxLength, String suffix) {
        this(maxLength);
        this.suffix = suffix;
    }

    public String getNewTicketId(String prefix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        buffer.append("-");
        buffer.append(this.numericGenerator.getNextNumberAsString());
        buffer.append("-");
        buffer.append(this.randomStringGenerator.getNewString());
        if (this.suffix != null) {
            buffer.append("-");
            buffer.append(this.suffix);
        }
        return buffer.toString();
    }
}

