/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.HttpBasedServiceCredentials;
import org.jasig.cas.authentication.principal.SimpleService;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.proxy.ProxyHandler;
import org.jasig.cas.ticket.proxy.support.Cas20ProxyHandler;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.Cas20ProtocolValidationSpecification;
import org.jasig.cas.validation.ValidationSpecification;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.BindUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class ServiceValidateController
extends AbstractController
implements InitializingBean {
    private static final String DEFAULT_SERVICE_FAILURE_VIEW_NAME = "casServiceFailureView";
    private static final String DEFAULT_SERVICE_SUCCESS_VIEW_NAME = "casServiceSuccessView";
    private CentralAuthenticationService centralAuthenticationService;
    private Class validationSpecificationClass;
    private ProxyHandler proxyHandler;
    private String successView;
    private String failureView;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.centralAuthenticationService);
        if (this.validationSpecificationClass == null) {
            this.validationSpecificationClass = Cas20ProtocolValidationSpecification.class;
            this.logger.info((Object)("No authentication specification class set.  Defaulting to " + this.validationSpecificationClass.getName()));
        }
        if (this.successView == null) {
            this.successView = DEFAULT_SERVICE_SUCCESS_VIEW_NAME;
            this.logger.info((Object)("No successView specified.  Using default of " + this.successView));
        }
        if (this.failureView == null) {
            this.failureView = DEFAULT_SERVICE_FAILURE_VIEW_NAME;
            this.logger.info((Object)("No failureView specified.  Using default of " + this.failureView));
        }
        if (this.proxyHandler == null) {
            this.proxyHandler = new Cas20ProxyHandler();
            ((Cas20ProxyHandler)this.proxyHandler).afterPropertiesSet();
            this.logger.info((Object)("No proxyHandler specified.  Defaulting to " + this.proxyHandler.getClass().getName()));
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceTicketId = request.getParameter("ticket");
        String service = request.getParameter("service");
        HashMap<String, Object> model = new HashMap<String, Object>();
        ValidationSpecification authenticationSpecification = this.getCommandClass();
        String pgtUrl = request.getParameter("pgtUrl");
        String proxyGrantingTicketId = null;
        HttpBasedServiceCredentials serviceCredentials = null;
        if (!StringUtils.hasText((String)service) || !StringUtils.hasText((String)serviceTicketId)) {
            model.put("code", "INVALID_REQUEST");
            model.put("description", this.getMessageSourceAccessor().getMessage("INVALID_REQUEST", "INVALID_REQUEST"));
            return new ModelAndView(this.failureView, model);
        }
        BindUtils.bind((ServletRequest)request, (Object)authenticationSpecification, (String)"authenticationSpecification");
        try {
            Assertion assertion;
            if (StringUtils.hasText((String)pgtUrl)) {
                try {
                    serviceCredentials = new HttpBasedServiceCredentials(new URL(pgtUrl));
                    proxyGrantingTicketId = this.centralAuthenticationService.delegateTicketGrantingTicket(serviceTicketId, serviceCredentials);
                }
                catch (TicketException e) {
                    this.logger.error((Object)("TicketException generating ticket for: " + pgtUrl), (Throwable)e);
                }
                catch (MalformedURLException e) {
                    this.logger.error((Object)"Exception converting pgtUrl to class URL", (Throwable)e);
                }
            }
            if (!authenticationSpecification.isSatisfiedBy(assertion = this.centralAuthenticationService.validateServiceTicket(serviceTicketId, new SimpleService(service)))) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("ServiceTicket [" + serviceTicketId + "] does not satisfy authentication specification."));
                }
                model.put("code", "INVALID_TICKET");
                model.put("description", this.getMessageSourceAccessor().getMessage("INVALID_TICKET_SPEC", "INVALID_TICKET_SPEC"));
                return new ModelAndView(this.failureView, model);
            }
            if (StringUtils.hasText((String)pgtUrl) && proxyGrantingTicketId != null) {
                String proxyIou = this.proxyHandler.handle(serviceCredentials, proxyGrantingTicketId);
                model.put("pgtIou", proxyIou);
            }
            model.put("assertion", assertion);
            return new ModelAndView(this.successView, model);
        }
        catch (TicketException te) {
            model.put("code", te.getCode());
            model.put("description", this.getMessageSourceAccessor().getMessage(te.getCode(), new Object[]{serviceTicketId}, te.getCode()));
            return new ModelAndView(this.failureView, model);
        }
    }

    private ValidationSpecification getCommandClass() {
        try {
            return (ValidationSpecification)this.validationSpecificationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setValidationSpecificationClass(Class validationSpecificationClass) {
        this.validationSpecificationClass = validationSpecificationClass;
    }

    public void setFailureView(String failureView) {
        this.failureView = failureView;
    }

    public void setSuccessView(String successView) {
        this.successView = successView;
    }

    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }
}

