/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.SimpleService;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.validation.UsernamePasswordCredentialsValidator;
import org.jasig.cas.web.bind.CredentialsBinder;
import org.jasig.cas.web.flow.util.ContextUtils;
import org.jasig.cas.web.util.SecureCookieGenerator;
import org.jasig.cas.web.util.WebUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.action.FormObjectAccessor;

public final class AuthenticationViaFormAction
extends FormAction
implements InitializingBean {
    private CredentialsBinder credentialsBinder;
    private CentralAuthenticationService centralAuthenticationService;
    private SecureCookieGenerator warnCookieGenerator;
    private SecureCookieGenerator ticketGrantingTicketCookieGenerator;

    protected void doBind(RequestContext context, DataBinder binder) throws Exception {
        HttpServletRequest request = ContextUtils.getHttpServletRequest(context);
        Credentials credentials = (Credentials)binder.getTarget();
        if (this.credentialsBinder != null) {
            this.credentialsBinder.bind(request, credentials);
        }
        super.doBind(context, binder);
    }

    public Event submit(RequestContext context) throws Exception {
        boolean warn;
        HttpServletResponse response;
        Credentials credentials;
        block6: {
            credentials = (Credentials)this.getFormObject(context);
            HttpServletRequest request = ContextUtils.getHttpServletRequest(context);
            response = ContextUtils.getHttpServletResponse(context);
            warn = WebUtils.getRequestParameterAsBoolean(request, "warn");
            boolean renew = WebUtils.getRequestParameterAsBoolean(request, "renew");
            String service = WebUtils.getRequestParameterAsString(request, "service");
            String ticketGrantingTicketIdFromCookie = this.ticketGrantingTicketCookieGenerator.getCookieValue(request);
            if (renew && StringUtils.hasText((String)ticketGrantingTicketIdFromCookie) && StringUtils.hasText((String)service)) {
                try {
                    String serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketIdFromCookie, new SimpleService(service), credentials);
                    ContextUtils.addAttribute(context, "ticket", serviceTicketId);
                    this.setWarningCookie(response, warn);
                    return this.warn();
                }
                catch (TicketException e) {
                    if (e.getCause() != null && AuthenticationException.class.isAssignableFrom(e.getCause().getClass())) {
                        this.populateErrorsInstance(context, e);
                        return this.error();
                    }
                    this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketIdFromCookie);
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug((Object)"Attempted to generate a ServiceTicket using renew=true with different credentials", (Throwable)e);
                }
            }
        }
        try {
            String ticketGrantingTicketId = this.centralAuthenticationService.createTicketGrantingTicket(credentials);
            ContextUtils.addAttribute(context, "ticketGrantingTicketId", ticketGrantingTicketId);
            this.setWarningCookie(response, warn);
            return this.success();
        }
        catch (TicketException e) {
            this.populateErrorsInstance(context, e);
            return this.error();
        }
    }

    private Event warn() {
        return this.result("warn");
    }

    private void populateErrorsInstance(RequestContext context, TicketException e) {
        FormObjectAccessor accessor = new FormObjectAccessor(context);
        Errors errors = accessor.getFormErrors(this.getFormObjectName(), this.getFormErrorsScope());
        errors.reject(e.getCode(), e.getCode());
    }

    private void setWarningCookie(HttpServletResponse response, boolean warn) {
        if (warn) {
            this.warnCookieGenerator.addCookie(response);
        } else {
            this.warnCookieGenerator.removeCookie(response);
        }
    }

    public void setTicketGrantingTicketCookieGenerator(SecureCookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    public void setWarnCookieGenerator(SecureCookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setCredentialsBinder(CredentialsBinder credentialsBinder) {
        this.credentialsBinder = credentialsBinder;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.centralAuthenticationService);
        Assert.notNull((Object)((Object)this.warnCookieGenerator));
        Assert.notNull((Object)((Object)this.ticketGrantingTicketCookieGenerator));
        if (this.getFormObjectClass() == null) {
            this.setFormObjectClass(UsernamePasswordCredentials.class);
            this.setFormObjectName("credentials");
            this.setValidator(new UsernamePasswordCredentialsValidator());
            this.logger.info((Object)("FormObjectClass not set.  Using default class of " + this.getFormObjectClass().getName() + " with formObjectName " + this.getFormObjectName() + " and validator " + this.getValidator().getClass().getName() + "."));
        }
        Assert.isTrue((boolean)Credentials.class.isAssignableFrom(this.getFormObjectClass()), (String)"CommandClass must be of type Credentials.");
        if (this.credentialsBinder != null && !this.credentialsBinder.supports(this.getFormObjectClass())) {
            throw new IllegalStateException("CredentialsBinder does not support supplied FormObjectClass: " + ((Object)((Object)this)).getClass().getName());
        }
    }
}

