/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public final class SecureCookieGenerator
extends CookieGenerator {
    private static final boolean DEFAULT_SECURE_VALUE = true;
    private String cookieValue;
    private boolean cookieSecure = true;

    protected Cookie createCookie(String cookieValue) {
        Cookie cookie = super.createCookie(cookieValue);
        cookie.setSecure(this.cookieSecure);
        return cookie;
    }

    public void addCookie(HttpServletResponse response) {
        this.addCookie(response, this.cookieValue == null ? "" : this.cookieValue);
    }

    public String getCookieValue(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
        return cookie == null ? null : cookie.getValue();
    }

    public String getCookieValue() {
        return this.cookieValue;
    }

    public void setCookieValue(String cookieValue) {
        this.cookieValue = cookieValue;
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }
}

