/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.convertor;

import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.bean.DbType;
import cn.zhxu.bs.util.StringUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListFieldConvertor
implements FieldConvertor.BFieldConvertor {
    private String itemSeparator = ",";
    private List<Convertor<?>> convertors = Collections.emptyList();

    public ListFieldConvertor() {
    }

    public ListFieldConvertor(String itemSeparator) {
        this.itemSeparator = Objects.requireNonNull(itemSeparator);
    }

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        if (valueType == String.class) {
            return meta.getType() == List.class && meta.getDbType() == DbType.UNKNOWN;
        }
        return false;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        String strValue = (String)value;
        if (StringUtils.isBlank(strValue)) {
            return Collections.emptyList();
        }
        Stream<String> stream = Arrays.stream(strValue.split(this.itemSeparator));
        Type genericType = meta.getField().getGenericType();
        if (genericType instanceof ParameterizedType) {
            Type type = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            return stream.map(v -> this.convert(type, (String)v)).collect(Collectors.toList());
        }
        return stream.collect(Collectors.toList());
    }

    protected Object convert(Type type, String value) {
        if (type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Short.class) {
            return Short.parseShort(value);
        }
        if (type == Byte.class) {
            return Byte.parseByte(value);
        }
        if (type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (type == BigInteger.class) {
            return new BigInteger(value);
        }
        for (Convertor<?> convertor : this.convertors) {
            if (!this.match(type, convertor.getClass())) continue;
            return convertor.convert(value);
        }
        return value;
    }

    protected boolean match(Type targetType, Class<?> convertorClass) {
        Type type = convertorClass.getGenericInterfaces()[0];
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0] == targetType;
        }
        return false;
    }

    public String getItemSeparator() {
        return this.itemSeparator;
    }

    public void setItemSeparator(String itemSeparator) {
        this.itemSeparator = Objects.requireNonNull(itemSeparator);
    }

    public List<Convertor<?>> getConvertors() {
        return this.convertors;
    }

    public void setConvertors(List<Convertor<?>> convertors) {
        this.convertors = Objects.requireNonNull(convertors);
    }

    public static interface Convertor<T> {
        public T convert(String var1);
    }
}

