/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.filter;

import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.ParamFilter;
import cn.zhxu.data.Array;
import cn.zhxu.xjson.JsonKit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class JsonArrayParamFilter
implements ParamFilter {
    private final String separator;

    public JsonArrayParamFilter() {
        this("-");
    }

    public JsonArrayParamFilter(String separator) {
        this.separator = Objects.requireNonNull(separator);
    }

    @Override
    public <T> Map<String, Object> doFilter(BeanMeta<T> beanMeta, Map<String, Object> paraMap) {
        HashMap<String, String> newMap = null;
        for (Map.Entry<String, Object> entry : paraMap.entrySet()) {
            Array array;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!this.likelyJsonArr(value) || key == null || key.contains(this.separator)) continue;
            try {
                array = JsonKit.toArray((String)((String)value));
            }
            catch (Exception ignore) {
                continue;
            }
            if (array.isEmpty()) continue;
            if (newMap == null) {
                newMap = new HashMap<String, String>();
            }
            for (int i = 0; i < array.size(); ++i) {
                newMap.put(key + this.separator + i, array.getString(i));
            }
        }
        if (newMap != null) {
            paraMap.putAll(newMap);
        }
        return paraMap;
    }

    protected boolean likelyJsonArr(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            return s.startsWith("[") && s.endsWith("]");
        }
        return false;
    }

    public String getSeparator() {
        return this.separator;
    }
}

