/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.group;

import cn.zhxu.bs.group.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Group<V> {
    public static final int TYPE_AND = 1;
    public static final int TYPE_OR = 2;
    public static final int TYPE_RAW = 3;
    private final int type;
    private final List<Group<V>> groups;
    private final V value;
    private static final Event EVENT_START = new Event(2);
    private static final Event EVENT_END = new Event(3);
    private static final Event EVENT_AND = new Event(4);
    private static final Event EVENT_OR = new Event(5);

    public Group(int type) {
        this(type, Collections.emptyList());
    }

    public Group(int type, List<Group<V>> groups) {
        this(type, Objects.requireNonNull(groups), null);
    }

    public Group(V value) {
        this(3, Collections.emptyList(), Objects.requireNonNull(value));
    }

    private Group(int type, List<Group<V>> groups, V value) {
        this.type = type;
        this.groups = groups;
        this.value = value;
    }

    public <R> Group<R> transform(Function<V, R> transformer) {
        if (this.type == 3) {
            return new Group<R>(transformer.apply(this.value));
        }
        List<Group<V>> newGroups = this.groups.stream().map(g -> g.transform(transformer)).collect(Collectors.toList());
        return new Group<V>(this.type, newGroups);
    }

    public Group<V> filter(Predicate<V> predicate) {
        if (this.type == 3) {
            return this;
        }
        ArrayList<Group<V>> newGroups = new ArrayList<Group<V>>();
        for (Group<V> group : this.groups) {
            if (group.type == 3) {
                if (!predicate.test(group.value)) continue;
                newGroups.add(group);
                continue;
            }
            Group<V> newGroup = group.filter(predicate);
            if (newGroup.type != 3 && newGroup.groups.size() <= 0) continue;
            newGroups.add(newGroup);
        }
        if (newGroups.size() == 1) {
            return (Group)newGroups.get(0);
        }
        return new Group<V>(this.type, newGroups);
    }

    public boolean judgeAny(Predicate<V> evaluator) {
        if (this.type == 3) {
            return evaluator.test(this.value);
        }
        for (Group<V> group : this.groups) {
            if (!group.judgeAny(evaluator)) continue;
            return true;
        }
        return false;
    }

    public boolean judgeAll(Predicate<V> evaluator) {
        if (this.type == 3) {
            return evaluator.test(this.value);
        }
        for (Group<V> group : this.groups) {
            if (group.judgeAll(evaluator)) continue;
            return false;
        }
        return true;
    }

    public void forEach(Consumer<Event<V>> consumer) {
        if (this.type == 3) {
            consumer.accept(new Event<V>(1, this.value));
            return;
        }
        if (this.groups.isEmpty()) {
            return;
        }
        consumer.accept(EVENT_START);
        int size = this.groups.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                consumer.accept(this.type == 1 ? EVENT_AND : EVENT_OR);
            }
            this.groups.get(i).forEach(consumer);
        }
        consumer.accept(EVENT_END);
    }

    public int complexity() {
        if (this.type == 3) {
            return 1;
        }
        int sum = 0;
        for (Group<V> group : this.groups) {
            sum += group.complexity();
        }
        return sum;
    }

    public Group<V> and(Group<V> other) {
        return this.boolWith(1, other);
    }

    public Group<V> or(Group<V> other) {
        return this.boolWith(2, other);
    }

    private Group<V> boolWith(int opType, Group<V> other) {
        if (this.equals(other)) {
            return this;
        }
        Group<V> res = Group.simplyBool(this, other, opType);
        if (res != null) {
            return res;
        }
        res = Group.simplyBool(other, this, opType);
        if (res != null) {
            return res;
        }
        if (this.type == opType) {
            return this.sameBool(other);
        }
        if (other.type == opType) {
            return super.sameBool(this);
        }
        return new Group<V>(opType, Arrays.asList(this, other));
    }

    private Group<V> sameBool(Group<V> other) {
        if (this.type == 3) {
            throw new IllegalStateException("This method can not be invoked on raw group: " + this);
        }
        ArrayList<Group<V>> groups = new ArrayList<Group<V>>();
        for (Group<V> group : this.groups) {
            Group<V> group2 = super.boolWith(this.type, other);
            if (group2.equals(group)) {
                return this;
            }
            if (other.equals(group2)) continue;
            groups.add(group);
        }
        if (groups.isEmpty()) {
            return other;
        }
        int oComplexity = other.complexity();
        for (Group group : groups) {
            int gComplexity = group.complexity();
            Group<V> res = super.boolWith(this.type, group);
            if (res.complexity() >= oComplexity + gComplexity) continue;
            groups.remove(group);
            groups.add(res);
            return new Group<V>(this.type, groups);
        }
        groups.add(other);
        return new Group<V>(this.type, groups);
    }

    private static <V> Group<V> simplyBool(Group<V> g1, Group<V> g2, int opType) {
        if (g1.type != 3 && g1.groups.size() == 1) {
            return super.boolWith(opType, g2);
        }
        if (g1.type != 3 && g1.groups.contains(g2)) {
            return g1.type == opType ? g1 : g2;
        }
        if (g1.type != 3 && g1.type != opType) {
            if (g1.type == g2.type) {
                List sames = g1.groups.stream().filter(g2.groups::contains).collect(Collectors.toList());
                if (sames.size() == g1.groups.size() || sames.size() == g2.groups.size()) {
                    return new Group<V>(g1.type, sames);
                }
                if (sames.size() > 0) {
                    List<Group<V>> others1 = g1.groups.stream().filter((? super T g) -> !sames.contains(g)).collect(Collectors.toList());
                    List<Group<V>> others2 = g2.groups.stream().filter((? super T g) -> !sames.contains(g)).collect(Collectors.toList());
                    Group<V> groups1 = others1.size() == 1 ? (Group)others1.get(0) : new Group<V>(g1.type, others1);
                    Group<V> groups2 = others2.size() == 1 ? (Group)others2.get(0) : new Group<V>(g2.type, others2);
                    ArrayList<Group<V>> children = new ArrayList<Group<V>>(sames);
                    children.add(new Group<V>(opType, Arrays.asList(groups1, groups2)));
                    return new Group<V>(g1.type, children);
                }
            }
            for (Group<V> group : g1.groups) {
                List<Group<V>> list;
                if (group.type != opType || (list = group.groups.stream().filter((? super T g) -> !g.equals(g2)).collect(Collectors.toList())).size() >= group.groups.size()) continue;
                Group<V> newGroup = new Group<V>(group.type, list);
                for (Group<V> g3 : g1.groups) {
                    if (g3 == group) continue;
                    newGroup = super.boolWith(g1.type, g3);
                }
                return super.boolWith(opType, g2);
            }
        }
        return null;
    }

    public boolean isRaw() {
        return this.type == 3;
    }

    public boolean isAnd() {
        return this.type == 1;
    }

    public boolean isOr() {
        return this.type == 2;
    }

    public V getValue() {
        return this.value;
    }

    public List<Group<V>> getGroups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group other = (Group)o;
        if (this.type != other.type) {
            return false;
        }
        return Objects.equals(this.groups, other.groups) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.groups, this.value);
    }

    public String toString() {
        if (this.type == 1) {
            return this.groups.stream().map(g -> {
                if (g.type == 2) {
                    return "(" + g + ")";
                }
                return g.toString();
            }).collect(Collectors.joining("&"));
        }
        if (this.type == 2) {
            return this.groups.stream().map(Group::toString).collect(Collectors.joining("|"));
        }
        return this.value != null ? this.value.toString() : "";
    }
}

