/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.implement;

import cn.zhxu.bs.DbMapping;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.SearchException;
import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.DbType;
import cn.zhxu.bs.bean.InheritType;
import cn.zhxu.bs.bean.SearchBean;
import cn.zhxu.bs.bean.SortType;
import cn.zhxu.bs.implement.DefaultDbTypeMapper;
import cn.zhxu.bs.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DefaultDbMapping
implements DbMapping {
    protected static final Class<FieldOp>[] EMPTY_OPERATORS = new Class[0];
    protected static final Pattern SINGLE_TABLE_PATTERN = Pattern.compile("\\w+|\\w+\\s+\\w+");
    private DbMapping.DbTypeMapper dbTypeMapper = new DefaultDbTypeMapper();
    private String tablePrefix;
    private boolean upperCase = false;
    private boolean underlineCase = true;
    private InheritType defaultInheritType = InheritType.ALL;
    private SortType defaultSortType = SortType.ALLOW_PARAM;
    private String[] redundantSuffixes;
    private String[] ignoreFields;
    private String aroundChar;

    @Override
    public InheritType inheritType(Class<?> beanClass) {
        InheritType iType;
        SearchBean bean = this.getSearchBean(beanClass);
        if (bean != null && (iType = bean.inheritType()) != InheritType.DEFAULT) {
            return iType;
        }
        return this.defaultInheritType;
    }

    @Override
    public DbMapping.Table table(Class<?> beanClass) {
        SearchBean bean = this.getSearchBean(beanClass);
        if (bean != null) {
            return new DbMapping.Table(bean.dataSource().trim(), this.tables(beanClass, bean), bean.where().trim(), bean.groupBy().trim(), bean.having().trim(), bean.distinct(), bean.orderBy(), this.sortable(bean.sortType()), bean.timeout(), this.columns(beanClass, bean.fields()));
        }
        return new DbMapping.Table(this.toTableName(beanClass));
    }

    protected boolean sortable(SortType sortType) {
        if (sortType == SortType.ALLOW_PARAM) {
            return true;
        }
        if (sortType == SortType.ONLY_ENTITY) {
            return false;
        }
        return this.defaultSortType == SortType.ALLOW_PARAM;
    }

    public List<DbMapping.Column> columns(Class<?> beanClass, DbField[] fields) {
        return Arrays.stream(fields).map(field -> this.column(beanClass, new BeanField((DbField)field, beanClass){
            final /* synthetic */ DbField val$field;
            final /* synthetic */ Class val$beanClass;
            {
                this.val$field = dbField;
                this.val$beanClass = clazz;
            }

            @Override
            public String getName() {
                String name = this.val$field.name();
                if (StringUtils.isBlank(name)) {
                    throw new SearchException("The name of @DbField in @SearchBean.fields on [" + this.val$beanClass.getName() + "] is not assigned.");
                }
                return name;
            }

            @Override
            public Class<?> getType() {
                return null;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)(annotationClass == DbField.class ? this.val$field : null);
            }

            @Override
            public Class<?> getDeclaringClass() {
                return this.val$beanClass;
            }
        })).collect(Collectors.toList());
    }

    @Override
    public DbMapping.Column column(Class<?> beanClass, final Field field) {
        return this.column(beanClass, new BeanField(){

            @Override
            public String getName() {
                return field.getName();
            }

            @Override
            public Class<?> getType() {
                return field.getType();
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return field.getAnnotation(annotationClass);
            }

            @Override
            public Class<?> getDeclaringClass() {
                return field.getDeclaringClass();
            }
        });
    }

    public DbMapping.Column column(Class<?> beanClass, BeanField field) {
        String fieldSql = this.dbFieldSql(beanClass, field);
        if (fieldSql == null) {
            return null;
        }
        Class<?> fieldType = field.getType();
        DbField dbField = field.getAnnotation(DbField.class);
        if (dbField != null) {
            DbType dbType = dbField.type();
            if (dbType == DbType.UNKNOWN && fieldType != null) {
                dbType = this.dbTypeMapper.map(fieldType);
            }
            String name = StringUtils.isBlank(dbField.name()) ? field.getName() : dbField.name();
            return new DbMapping.Column(name, fieldSql, dbField.conditional(), dbField.onlyOn(), dbField.alias(), dbType, dbField.cluster());
        }
        DbType dbType = fieldType != null ? this.dbTypeMapper.map(fieldType) : DbType.UNKNOWN;
        return new DbMapping.Column(field.getName(), fieldSql, true, EMPTY_OPERATORS, dbType);
    }

    public SearchBean getSearchBean(Class<?> beanClass) {
        while (beanClass != Object.class) {
            SearchBean bean = beanClass.getAnnotation(SearchBean.class);
            if (bean != null) {
                return bean;
            }
            if (this.defaultInheritType != InheritType.TABLE && this.defaultInheritType != InheritType.ALL) break;
            beanClass = beanClass.getSuperclass();
        }
        return null;
    }

    public String tables(Class<?> beanClass, SearchBean bean) {
        String tables = bean.tables();
        if (StringUtils.isBlank(tables)) {
            return this.toTableName(beanClass);
        }
        return tables.trim();
    }

    public String toTableName(Class<?> beanClass) {
        String name = this.simplify(beanClass.getSimpleName());
        if (this.underlineCase) {
            name = StringUtils.toUnderline(name);
        }
        if (this.upperCase) {
            name = name.toUpperCase();
        }
        if (this.tablePrefix != null) {
            name = this.tablePrefix + name;
        }
        if (this.aroundChar != null) {
            name = this.aroundChar + name + this.aroundChar;
        }
        return name;
    }

    public String simplify(String className) {
        if (this.redundantSuffixes != null) {
            int length = className.length();
            for (String suffix : this.redundantSuffixes) {
                if (length <= suffix.length() || !className.endsWith(suffix)) continue;
                return className.substring(0, length - suffix.length());
            }
        }
        return className;
    }

    public String dbFieldSql(Class<?> beanClass, BeanField field) {
        String autoMapTo;
        String mapTo;
        DbField dbField = field.getAnnotation(DbField.class);
        if (field.getAnnotation(DbIgnore.class) != null) {
            if (dbField == null) {
                return null;
            }
            throw new SearchException("[" + beanClass.getName() + ": " + field.getName() + "] is annotated by @DbField and @DbIgnore, which are mutually exclusive.");
        }
        SearchBean bean = this.getSearchBean(beanClass);
        if (bean != null && this.shouldIgnore(field, bean.ignoreFields())) {
            if (dbField == null) {
                return null;
            }
            int res = this.compareFieldToBeanAnnotation(field, beanClass);
            if (res == 0) {
                throw new SearchException("[" + beanClass.getName() + ": " + field.getName() + "] is annotated by @DbField and listed by @SearchBean.ignoreFields in same class, which are mutually exclusive.");
            }
            if (res > 0) {
                return null;
            }
        }
        String string = mapTo = dbField != null ? dbField.mapTo().trim() : null;
        if (dbField != null) {
            String fieldSql = dbField.value().trim();
            if (StringUtils.isNotBlank(fieldSql)) {
                if (fieldSql.toLowerCase().startsWith("select ")) {
                    return "(" + fieldSql + ")";
                }
                return this.withMapTo(fieldSql, mapTo);
            }
        } else if (this.shouldIgnore(field, this.ignoreFields)) {
            return null;
        }
        if (StringUtils.isNotBlank(mapTo)) {
            return this.withMapTo(this.toColumnName(field), mapTo);
        }
        String string2 = autoMapTo = bean != null ? bean.autoMapTo().trim() : null;
        if (StringUtils.isNotBlank(autoMapTo)) {
            return this.withMapTo(this.toColumnName(field), autoMapTo);
        }
        if (this.isMapToSingleTable(bean)) {
            return this.toColumnName(field);
        }
        return null;
    }

    public String withMapTo(String fieldSql, String mapTo) {
        if (StringUtils.isBlank(mapTo)) {
            return fieldSql;
        }
        return mapTo + "." + fieldSql;
    }

    public boolean isMapToSingleTable(SearchBean bean) {
        if (bean == null) {
            return true;
        }
        String tables = bean.tables().trim();
        return StringUtils.isBlank(tables) || SINGLE_TABLE_PATTERN.matcher(tables).matches();
    }

    public int compareFieldToBeanAnnotation(BeanField field, Class<?> beanClass) {
        int fieldLevel = 0;
        int beanLevel = 0;
        Class<?> clazz = beanClass;
        while (clazz != field.getDeclaringClass() && clazz != Object.class) {
            clazz = clazz.getSuperclass();
            ++fieldLevel;
        }
        clazz = beanClass;
        while (clazz.getAnnotation(SearchBean.class) == null && clazz != Object.class) {
            clazz = clazz.getSuperclass();
            ++beanLevel;
        }
        return fieldLevel - beanLevel;
    }

    public boolean shouldIgnore(BeanField field, String[] ignoreFields) {
        if (ignoreFields != null) {
            String name = field.getName();
            for (String igField : ignoreFields) {
                if (!name.equals(igField)) continue;
                return true;
            }
        }
        return false;
    }

    public String toColumnName(BeanField field) {
        String name = field.getName();
        if (this.underlineCase) {
            name = StringUtils.toUnderline(name);
        }
        String string = name = this.upperCase ? name.toUpperCase() : name;
        if (this.aroundChar != null) {
            name = this.aroundChar + name + this.aroundChar;
        }
        return name;
    }

    public DbMapping.DbTypeMapper getDbTypeMapper() {
        return this.dbTypeMapper;
    }

    public void setDbTypeMapper(DbMapping.DbTypeMapper dbTypeMapper) {
        this.dbTypeMapper = Objects.requireNonNull(dbTypeMapper);
    }

    public InheritType getDefaultInheritType() {
        return this.defaultInheritType;
    }

    public void setDefaultInheritType(InheritType inheritType) {
        this.defaultInheritType = Objects.requireNonNull(inheritType);
    }

    public SortType getDefaultSortType() {
        return this.defaultSortType;
    }

    public void setDefaultSortType(SortType defaultSortType) {
        this.defaultSortType = Objects.requireNonNull(defaultSortType);
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        if (StringUtils.isNotBlank(tablePrefix)) {
            this.tablePrefix = tablePrefix.trim();
        }
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    public boolean isUnderlineCase() {
        return this.underlineCase;
    }

    public void setUnderlineCase(boolean underlineCase) {
        this.underlineCase = underlineCase;
    }

    public String[] getRedundantSuffixes() {
        return this.redundantSuffixes;
    }

    public void setRedundantSuffixes(String[] redundantSuffixes) {
        this.redundantSuffixes = redundantSuffixes;
    }

    public String[] getIgnoreFields() {
        return this.ignoreFields;
    }

    public void setIgnoreFields(String[] ignoreFields) {
        this.ignoreFields = ignoreFields;
    }

    public String getAroundChar() {
        return this.aroundChar;
    }

    public void setAroundChar(String aroundChar) {
        this.aroundChar = aroundChar;
    }

    public static interface BeanField {
        public String getName();

        public Class<?> getType();

        public <T extends Annotation> T getAnnotation(Class<T> var1);

        public Class<?> getDeclaringClass();
    }
}

