/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PaymentInstrumentRequirement
 */
@JsonPropertyOrder({
  PaymentInstrumentRequirement.JSON_PROPERTY_DESCRIPTION,
  PaymentInstrumentRequirement.JSON_PROPERTY_ISSUING_COUNTRY_CODE,
  PaymentInstrumentRequirement.JSON_PROPERTY_ISSUING_COUNTRY_CODES,
  PaymentInstrumentRequirement.JSON_PROPERTY_ONLY_FOR_CROSS_BALANCE_PLATFORM,
  PaymentInstrumentRequirement.JSON_PROPERTY_PAYMENT_INSTRUMENT_TYPE,
  PaymentInstrumentRequirement.JSON_PROPERTY_TYPE
})

public class PaymentInstrumentRequirement {
  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_ISSUING_COUNTRY_CODE = "issuingCountryCode";
  private String issuingCountryCode;

  public static final String JSON_PROPERTY_ISSUING_COUNTRY_CODES = "issuingCountryCodes";
  private List<String> issuingCountryCodes = null;

  public static final String JSON_PROPERTY_ONLY_FOR_CROSS_BALANCE_PLATFORM = "onlyForCrossBalancePlatform";
  private Boolean onlyForCrossBalancePlatform;

  /**
   * The type of the payment instrument. For example, \&quot;BankAccount\&quot; or \&quot;Card\&quot;.
   */
  public enum PaymentInstrumentTypeEnum {
    BANKACCOUNT("BankAccount"),
    
    CARD("Card");

    private String value;

    PaymentInstrumentTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentInstrumentTypeEnum fromValue(String value) {
      for (PaymentInstrumentTypeEnum b : PaymentInstrumentTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_TYPE = "paymentInstrumentType";
  private PaymentInstrumentTypeEnum paymentInstrumentType;

  /**
   * **paymentInstrumentRequirement**
   */
  public enum TypeEnum {
    PAYMENTINSTRUMENTREQUIREMENT("paymentInstrumentRequirement");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public PaymentInstrumentRequirement() { 
  }

  /**
   * Specifies the requirements for the payment instrument that need to be included in the request for a particular route.
   *
   * @param description
   * @return the current {@code PaymentInstrumentRequirement} instance, allowing for method chaining
   */
  public PaymentInstrumentRequirement description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Specifies the requirements for the payment instrument that need to be included in the request for a particular route.
   * @return description
   */
  @ApiModelProperty(value = "Specifies the requirements for the payment instrument that need to be included in the request for a particular route.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * Specifies the requirements for the payment instrument that need to be included in the request for a particular route.
   *
   * @param description
   */ 
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the payment instrument is issued. For example, **NL** or **US**.
   *
   * @param issuingCountryCode
   * @return the current {@code PaymentInstrumentRequirement} instance, allowing for method chaining
   */
  public PaymentInstrumentRequirement issuingCountryCode(String issuingCountryCode) {
    this.issuingCountryCode = issuingCountryCode;
    return this;
  }

  /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the payment instrument is issued. For example, **NL** or **US**.
   * @return issuingCountryCode
   */
  @ApiModelProperty(value = "The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the payment instrument is issued. For example, **NL** or **US**.")
  @JsonProperty(JSON_PROPERTY_ISSUING_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIssuingCountryCode() {
    return issuingCountryCode;
  }

  /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the payment instrument is issued. For example, **NL** or **US**.
   *
   * @param issuingCountryCode
   */ 
  @JsonProperty(JSON_PROPERTY_ISSUING_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuingCountryCode(String issuingCountryCode) {
    this.issuingCountryCode = issuingCountryCode;
  }

  /**
   * The two-character ISO-3166-1 alpha-2 country code list for payment instruments.
   *
   * @param issuingCountryCodes
   * @return the current {@code PaymentInstrumentRequirement} instance, allowing for method chaining
   */
  public PaymentInstrumentRequirement issuingCountryCodes(List<String> issuingCountryCodes) {
    this.issuingCountryCodes = issuingCountryCodes;
    return this;
  }

  public PaymentInstrumentRequirement addIssuingCountryCodesItem(String issuingCountryCodesItem) {
    if (this.issuingCountryCodes == null) {
      this.issuingCountryCodes = new ArrayList<>();
    }
    this.issuingCountryCodes.add(issuingCountryCodesItem);
    return this;
  }

  /**
   * The two-character ISO-3166-1 alpha-2 country code list for payment instruments.
   * @return issuingCountryCodes
   */
  @ApiModelProperty(value = "The two-character ISO-3166-1 alpha-2 country code list for payment instruments.")
  @JsonProperty(JSON_PROPERTY_ISSUING_COUNTRY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getIssuingCountryCodes() {
    return issuingCountryCodes;
  }

  /**
   * The two-character ISO-3166-1 alpha-2 country code list for payment instruments.
   *
   * @param issuingCountryCodes
   */ 
  @JsonProperty(JSON_PROPERTY_ISSUING_COUNTRY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuingCountryCodes(List<String> issuingCountryCodes) {
    this.issuingCountryCodes = issuingCountryCodes;
  }

  /**
   * Specifies if the requirement only applies to transfers to another balance platform.
   *
   * @param onlyForCrossBalancePlatform
   * @return the current {@code PaymentInstrumentRequirement} instance, allowing for method chaining
   */
  public PaymentInstrumentRequirement onlyForCrossBalancePlatform(Boolean onlyForCrossBalancePlatform) {
    this.onlyForCrossBalancePlatform = onlyForCrossBalancePlatform;
    return this;
  }

  /**
   * Specifies if the requirement only applies to transfers to another balance platform.
   * @return onlyForCrossBalancePlatform
   */
  @ApiModelProperty(value = "Specifies if the requirement only applies to transfers to another balance platform.")
  @JsonProperty(JSON_PROPERTY_ONLY_FOR_CROSS_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getOnlyForCrossBalancePlatform() {
    return onlyForCrossBalancePlatform;
  }

  /**
   * Specifies if the requirement only applies to transfers to another balance platform.
   *
   * @param onlyForCrossBalancePlatform
   */ 
  @JsonProperty(JSON_PROPERTY_ONLY_FOR_CROSS_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOnlyForCrossBalancePlatform(Boolean onlyForCrossBalancePlatform) {
    this.onlyForCrossBalancePlatform = onlyForCrossBalancePlatform;
  }

  /**
   * The type of the payment instrument. For example, \&quot;BankAccount\&quot; or \&quot;Card\&quot;.
   *
   * @param paymentInstrumentType
   * @return the current {@code PaymentInstrumentRequirement} instance, allowing for method chaining
   */
  public PaymentInstrumentRequirement paymentInstrumentType(PaymentInstrumentTypeEnum paymentInstrumentType) {
    this.paymentInstrumentType = paymentInstrumentType;
    return this;
  }

  /**
   * The type of the payment instrument. For example, \&quot;BankAccount\&quot; or \&quot;Card\&quot;.
   * @return paymentInstrumentType
   */
  @ApiModelProperty(value = "The type of the payment instrument. For example, \"BankAccount\" or \"Card\".")
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PaymentInstrumentTypeEnum getPaymentInstrumentType() {
    return paymentInstrumentType;
  }

  /**
   * The type of the payment instrument. For example, \&quot;BankAccount\&quot; or \&quot;Card\&quot;.
   *
   * @param paymentInstrumentType
   */ 
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentInstrumentType(PaymentInstrumentTypeEnum paymentInstrumentType) {
    this.paymentInstrumentType = paymentInstrumentType;
  }

  /**
   * **paymentInstrumentRequirement**
   *
   * @param type
   * @return the current {@code PaymentInstrumentRequirement} instance, allowing for method chaining
   */
  public PaymentInstrumentRequirement type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **paymentInstrumentRequirement**
   * @return type
   */
  @ApiModelProperty(required = true, value = "**paymentInstrumentRequirement**")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **paymentInstrumentRequirement**
   *
   * @param type
   */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this PaymentInstrumentRequirement object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentInstrumentRequirement paymentInstrumentRequirement = (PaymentInstrumentRequirement) o;
    return Objects.equals(this.description, paymentInstrumentRequirement.description) &&
        Objects.equals(this.issuingCountryCode, paymentInstrumentRequirement.issuingCountryCode) &&
        Objects.equals(this.issuingCountryCodes, paymentInstrumentRequirement.issuingCountryCodes) &&
        Objects.equals(this.onlyForCrossBalancePlatform, paymentInstrumentRequirement.onlyForCrossBalancePlatform) &&
        Objects.equals(this.paymentInstrumentType, paymentInstrumentRequirement.paymentInstrumentType) &&
        Objects.equals(this.type, paymentInstrumentRequirement.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, issuingCountryCode, issuingCountryCodes, onlyForCrossBalancePlatform, paymentInstrumentType, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentInstrumentRequirement {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    issuingCountryCode: ").append(toIndentedString(issuingCountryCode)).append("\n");
    sb.append("    issuingCountryCodes: ").append(toIndentedString(issuingCountryCodes)).append("\n");
    sb.append("    onlyForCrossBalancePlatform: ").append(toIndentedString(onlyForCrossBalancePlatform)).append("\n");
    sb.append("    paymentInstrumentType: ").append(toIndentedString(paymentInstrumentType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PaymentInstrumentRequirement given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentInstrumentRequirement
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentInstrumentRequirement
   */
  public static PaymentInstrumentRequirement fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentInstrumentRequirement.class);
  }
/**
  * Convert an instance of PaymentInstrumentRequirement to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
