/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.Links;
import com.adyen.model.management.Name;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CompanyUser
 */
@JsonPropertyOrder({
  CompanyUser.JSON_PROPERTY_LINKS,
  CompanyUser.JSON_PROPERTY_ACCOUNT_GROUPS,
  CompanyUser.JSON_PROPERTY_ACTIVE,
  CompanyUser.JSON_PROPERTY_APPS,
  CompanyUser.JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS,
  CompanyUser.JSON_PROPERTY_EMAIL,
  CompanyUser.JSON_PROPERTY_ID,
  CompanyUser.JSON_PROPERTY_NAME,
  CompanyUser.JSON_PROPERTY_ROLES,
  CompanyUser.JSON_PROPERTY_TIME_ZONE_CODE,
  CompanyUser.JSON_PROPERTY_USERNAME
})

public class CompanyUser {
  public static final String JSON_PROPERTY_LINKS = "_links";
  private Links links;

  public static final String JSON_PROPERTY_ACCOUNT_GROUPS = "accountGroups";
  private List<String> accountGroups = null;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_APPS = "apps";
  private List<String> apps = null;

  public static final String JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS = "associatedMerchantAccounts";
  private List<String> associatedMerchantAccounts = null;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private Name name;

  public static final String JSON_PROPERTY_ROLES = "roles";
  private List<String> roles = new ArrayList<>();

  public static final String JSON_PROPERTY_TIME_ZONE_CODE = "timeZoneCode";
  private String timeZoneCode;

  public static final String JSON_PROPERTY_USERNAME = "username";
  private String username;

  public CompanyUser() { 
  }

  /**
   * links
   *
   * @param links
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser links(Links links) {
    this.links = links;
    return this;
  }

  /**
   * links
   * @return links
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Links getLinks() {
    return links;
  }

  /**
   * links
   *
   * @param links
   */ 
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Links links) {
    this.links = links;
  }

  /**
   * The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.
   *
   * @param accountGroups
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser accountGroups(List<String> accountGroups) {
    this.accountGroups = accountGroups;
    return this;
  }

  public CompanyUser addAccountGroupsItem(String accountGroupsItem) {
    if (this.accountGroups == null) {
      this.accountGroups = new ArrayList<>();
    }
    this.accountGroups.add(accountGroupsItem);
    return this;
  }

  /**
   * The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.
   * @return accountGroups
   */
  @ApiModelProperty(value = "The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getAccountGroups() {
    return accountGroups;
  }

  /**
   * The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.
   *
   * @param accountGroups
   */ 
  @JsonProperty(JSON_PROPERTY_ACCOUNT_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountGroups(List<String> accountGroups) {
    this.accountGroups = accountGroups;
  }

  /**
   * Indicates whether this user is active.
   *
   * @param active
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser active(Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Indicates whether this user is active.
   * @return active
   */
  @ApiModelProperty(value = "Indicates whether this user is active.")
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getActive() {
    return active;
  }

  /**
   * Indicates whether this user is active.
   *
   * @param active
   */ 
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }

  /**
   * Set of apps available to this user
   *
   * @param apps
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser apps(List<String> apps) {
    this.apps = apps;
    return this;
  }

  public CompanyUser addAppsItem(String appsItem) {
    if (this.apps == null) {
      this.apps = new ArrayList<>();
    }
    this.apps.add(appsItem);
    return this;
  }

  /**
   * Set of apps available to this user
   * @return apps
   */
  @ApiModelProperty(value = "Set of apps available to this user")
  @JsonProperty(JSON_PROPERTY_APPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getApps() {
    return apps;
  }

  /**
   * Set of apps available to this user
   *
   * @param apps
   */ 
  @JsonProperty(JSON_PROPERTY_APPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApps(List<String> apps) {
    this.apps = apps;
  }

  /**
   * The list of [merchant accounts](https://docs.adyen.com/account/account-structure#merchant-accounts) associated with this user.
   *
   * @param associatedMerchantAccounts
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser associatedMerchantAccounts(List<String> associatedMerchantAccounts) {
    this.associatedMerchantAccounts = associatedMerchantAccounts;
    return this;
  }

  public CompanyUser addAssociatedMerchantAccountsItem(String associatedMerchantAccountsItem) {
    if (this.associatedMerchantAccounts == null) {
      this.associatedMerchantAccounts = new ArrayList<>();
    }
    this.associatedMerchantAccounts.add(associatedMerchantAccountsItem);
    return this;
  }

  /**
   * The list of [merchant accounts](https://docs.adyen.com/account/account-structure#merchant-accounts) associated with this user.
   * @return associatedMerchantAccounts
   */
  @ApiModelProperty(value = "The list of [merchant accounts](https://docs.adyen.com/account/account-structure#merchant-accounts) associated with this user.")
  @JsonProperty(JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getAssociatedMerchantAccounts() {
    return associatedMerchantAccounts;
  }

  /**
   * The list of [merchant accounts](https://docs.adyen.com/account/account-structure#merchant-accounts) associated with this user.
   *
   * @param associatedMerchantAccounts
   */ 
  @JsonProperty(JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssociatedMerchantAccounts(List<String> associatedMerchantAccounts) {
    this.associatedMerchantAccounts = associatedMerchantAccounts;
  }

  /**
   * The email address of the user.
   *
   * @param email
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser email(String email) {
    this.email = email;
    return this;
  }

  /**
   * The email address of the user.
   * @return email
   */
  @ApiModelProperty(required = true, value = "The email address of the user.")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmail() {
    return email;
  }

  /**
   * The email address of the user.
   *
   * @param email
   */ 
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * The unique identifier of the user.
   *
   * @param id
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the user.
   * @return id
   */
  @ApiModelProperty(required = true, value = "The unique identifier of the user.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the user.
   *
   * @param id
   */ 
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * name
   *
   * @param name
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser name(Name name) {
    this.name = name;
    return this;
  }

  /**
   * name
   * @return name
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Name getName() {
    return name;
  }

  /**
   * name
   *
   * @param name
   */ 
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(Name name) {
    this.name = name;
  }

  /**
   * The list of [roles](https://docs.adyen.com/account/user-roles) for this user.
   *
   * @param roles
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser roles(List<String> roles) {
    this.roles = roles;
    return this;
  }

  public CompanyUser addRolesItem(String rolesItem) {
    this.roles.add(rolesItem);
    return this;
  }

  /**
   * The list of [roles](https://docs.adyen.com/account/user-roles) for this user.
   * @return roles
   */
  @ApiModelProperty(required = true, value = "The list of [roles](https://docs.adyen.com/account/user-roles) for this user.")
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getRoles() {
    return roles;
  }

  /**
   * The list of [roles](https://docs.adyen.com/account/user-roles) for this user.
   *
   * @param roles
   */ 
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoles(List<String> roles) {
    this.roles = roles;
  }

  /**
   * The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.
   *
   * @param timeZoneCode
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser timeZoneCode(String timeZoneCode) {
    this.timeZoneCode = timeZoneCode;
    return this;
  }

  /**
   * The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.
   * @return timeZoneCode
   */
  @ApiModelProperty(required = true, value = "The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.")
  @JsonProperty(JSON_PROPERTY_TIME_ZONE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTimeZoneCode() {
    return timeZoneCode;
  }

  /**
   * The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.
   *
   * @param timeZoneCode
   */ 
  @JsonProperty(JSON_PROPERTY_TIME_ZONE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeZoneCode(String timeZoneCode) {
    this.timeZoneCode = timeZoneCode;
  }

  /**
   * The username for this user.
   *
   * @param username
   * @return the current {@code CompanyUser} instance, allowing for method chaining
   */
  public CompanyUser username(String username) {
    this.username = username;
    return this;
  }

  /**
   * The username for this user.
   * @return username
   */
  @ApiModelProperty(required = true, value = "The username for this user.")
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUsername() {
    return username;
  }

  /**
   * The username for this user.
   *
   * @param username
   */ 
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsername(String username) {
    this.username = username;
  }

  /**
   * Return true if this CompanyUser object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyUser companyUser = (CompanyUser) o;
    return Objects.equals(this.links, companyUser.links) &&
        Objects.equals(this.accountGroups, companyUser.accountGroups) &&
        Objects.equals(this.active, companyUser.active) &&
        Objects.equals(this.apps, companyUser.apps) &&
        Objects.equals(this.associatedMerchantAccounts, companyUser.associatedMerchantAccounts) &&
        Objects.equals(this.email, companyUser.email) &&
        Objects.equals(this.id, companyUser.id) &&
        Objects.equals(this.name, companyUser.name) &&
        Objects.equals(this.roles, companyUser.roles) &&
        Objects.equals(this.timeZoneCode, companyUser.timeZoneCode) &&
        Objects.equals(this.username, companyUser.username);
  }

  @Override
  public int hashCode() {
    return Objects.hash(links, accountGroups, active, apps, associatedMerchantAccounts, email, id, name, roles, timeZoneCode, username);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyUser {\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    accountGroups: ").append(toIndentedString(accountGroups)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    apps: ").append(toIndentedString(apps)).append("\n");
    sb.append("    associatedMerchantAccounts: ").append(toIndentedString(associatedMerchantAccounts)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    timeZoneCode: ").append(toIndentedString(timeZoneCode)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CompanyUser given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CompanyUser
   * @throws JsonProcessingException if the JSON string is invalid with respect to CompanyUser
   */
  public static CompanyUser fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CompanyUser.class);
  }
/**
  * Convert an instance of CompanyUser to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
