/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayaccount;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PayoutScheduleResponse
 */
@JsonPropertyOrder({
  PayoutScheduleResponse.JSON_PROPERTY_NEXT_SCHEDULED_PAYOUT,
  PayoutScheduleResponse.JSON_PROPERTY_SCHEDULE
})

public class PayoutScheduleResponse {
  public static final String JSON_PROPERTY_NEXT_SCHEDULED_PAYOUT = "nextScheduledPayout";
  private OffsetDateTime nextScheduledPayout;

  /**
   * The payout schedule of the account. Permitted values: &#x60;DEFAULT&#x60;, &#x60;DAILY&#x60;, &#x60;DAILY_US&#x60;, &#x60;DAILY_EU&#x60;, &#x60;DAILY_AU&#x60;, &#x60;DAILY_SG&#x60;, &#x60;WEEKLY&#x60;, &#x60;WEEKLY_ON_TUE_FRI_MIDNIGHT&#x60;, &#x60;BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT&#x60;, &#x60;MONTHLY&#x60;, &#x60;HOLD&#x60;.
   */
  public enum ScheduleEnum {
    DEFAULT("DEFAULT"),
    BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT("BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT"),
    
    DAILY("DAILY"),
    
    DAILY_AU("DAILY_AU"),
    
    DAILY_EU("DAILY_EU"),
    
    DAILY_SG("DAILY_SG"),
    
    DAILY_US("DAILY_US"),
    
    HOLD("HOLD"),
    
    MONTHLY("MONTHLY"),
    
    WEEKLY("WEEKLY"),
    
    WEEKLY_MON_TO_FRI_AU("WEEKLY_MON_TO_FRI_AU"),
    
    WEEKLY_MON_TO_FRI_EU("WEEKLY_MON_TO_FRI_EU"),
    
    WEEKLY_MON_TO_FRI_US("WEEKLY_MON_TO_FRI_US"),
    
    WEEKLY_ON_TUE_FRI_MIDNIGHT("WEEKLY_ON_TUE_FRI_MIDNIGHT"),
    
    WEEKLY_SUN_TO_THU_AU("WEEKLY_SUN_TO_THU_AU"),
    
    WEEKLY_SUN_TO_THU_US("WEEKLY_SUN_TO_THU_US");

    private String value;

    ScheduleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ScheduleEnum fromValue(String value) {
      for (ScheduleEnum b : ScheduleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SCHEDULE = "schedule";
  private ScheduleEnum schedule;

  public PayoutScheduleResponse() { 
  }

  public PayoutScheduleResponse nextScheduledPayout(OffsetDateTime nextScheduledPayout) {
    this.nextScheduledPayout = nextScheduledPayout;
    return this;
  }

   /**
   * The date of the next scheduled payout.
   * @return nextScheduledPayout
  **/
  @ApiModelProperty(value = "The date of the next scheduled payout.")
  @JsonProperty(JSON_PROPERTY_NEXT_SCHEDULED_PAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getNextScheduledPayout() {
    return nextScheduledPayout;
  }


  @JsonProperty(JSON_PROPERTY_NEXT_SCHEDULED_PAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNextScheduledPayout(OffsetDateTime nextScheduledPayout) {
    this.nextScheduledPayout = nextScheduledPayout;
  }


  public PayoutScheduleResponse schedule(ScheduleEnum schedule) {
    this.schedule = schedule;
    return this;
  }

   /**
   * The payout schedule of the account. Permitted values: &#x60;DEFAULT&#x60;, &#x60;DAILY&#x60;, &#x60;DAILY_US&#x60;, &#x60;DAILY_EU&#x60;, &#x60;DAILY_AU&#x60;, &#x60;DAILY_SG&#x60;, &#x60;WEEKLY&#x60;, &#x60;WEEKLY_ON_TUE_FRI_MIDNIGHT&#x60;, &#x60;BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT&#x60;, &#x60;MONTHLY&#x60;, &#x60;HOLD&#x60;.
   * @return schedule
  **/
  @ApiModelProperty(value = "The payout schedule of the account. Permitted values: `DEFAULT`, `DAILY`, `DAILY_US`, `DAILY_EU`, `DAILY_AU`, `DAILY_SG`, `WEEKLY`, `WEEKLY_ON_TUE_FRI_MIDNIGHT`, `BIWEEKLY_ON_1ST_AND_15TH_AT_MIDNIGHT`, `MONTHLY`, `HOLD`.")
  @JsonProperty(JSON_PROPERTY_SCHEDULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ScheduleEnum getSchedule() {
    return schedule;
  }


  @JsonProperty(JSON_PROPERTY_SCHEDULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSchedule(ScheduleEnum schedule) {
    this.schedule = schedule;
  }


  /**
   * Return true if this PayoutScheduleResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayoutScheduleResponse payoutScheduleResponse = (PayoutScheduleResponse) o;
    return Objects.equals(this.nextScheduledPayout, payoutScheduleResponse.nextScheduledPayout) &&
        Objects.equals(this.schedule, payoutScheduleResponse.schedule);
  }

  @Override
  public int hashCode() {
    return Objects.hash(nextScheduledPayout, schedule);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayoutScheduleResponse {\n");
    sb.append("    nextScheduledPayout: ").append(toIndentedString(nextScheduledPayout)).append("\n");
    sb.append("    schedule: ").append(toIndentedString(schedule)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PayoutScheduleResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PayoutScheduleResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to PayoutScheduleResponse
   */
  public static PayoutScheduleResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PayoutScheduleResponse.class);
  }
/**
  * Convert an instance of PayoutScheduleResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

