/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpaywebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpaywebhooks.Amount;
import com.adyen.model.marketpaywebhooks.BankAccountDetail;
import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.adyen.model.marketpaywebhooks.OperationStatus;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AccountHolderPayoutNotificationContent
 */
@JsonPropertyOrder({
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_ACCOUNT_CODE,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_ACCOUNT_HOLDER_CODE,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_AMOUNTS,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_BANK_ACCOUNT_DETAIL,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_DESCRIPTION,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_ESTIMATED_ARRIVAL_DATE,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_INVALID_FIELDS,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_MERCHANT_REFERENCE,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_ORIGINAL_PSP_REFERENCE,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_PAYOUT_ACCOUNT_COUNTRY,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_PAYOUT_ACCOUNT_NUMBER,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_PAYOUT_BALANCE_ACCOUNT_ID,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_PAYOUT_BANK_NAME,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_PAYOUT_BRANCH_CODE,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_PAYOUT_REFERENCE,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_PAYOUT_SPEED,
  AccountHolderPayoutNotificationContent.JSON_PROPERTY_STATUS
})

public class AccountHolderPayoutNotificationContent {
  public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
  private String accountCode;

  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
  private String accountHolderCode;

  public static final String JSON_PROPERTY_AMOUNTS = "amounts";
  private List<Amount> amounts = null;

  public static final String JSON_PROPERTY_BANK_ACCOUNT_DETAIL = "bankAccountDetail";
  private BankAccountDetail bankAccountDetail;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_ESTIMATED_ARRIVAL_DATE = "estimatedArrivalDate";
  private LocalDate estimatedArrivalDate;

  public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
  private List<ErrorFieldType> invalidFields = null;

  public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
  private String merchantReference;

  public static final String JSON_PROPERTY_ORIGINAL_PSP_REFERENCE = "originalPspReference";
  private String originalPspReference;

  public static final String JSON_PROPERTY_PAYOUT_ACCOUNT_COUNTRY = "payoutAccountCountry";
  private String payoutAccountCountry;

  public static final String JSON_PROPERTY_PAYOUT_ACCOUNT_NUMBER = "payoutAccountNumber";
  private String payoutAccountNumber;

  public static final String JSON_PROPERTY_PAYOUT_BALANCE_ACCOUNT_ID = "payoutBalanceAccountId";
  private String payoutBalanceAccountId;

  public static final String JSON_PROPERTY_PAYOUT_BANK_NAME = "payoutBankName";
  private String payoutBankName;

  public static final String JSON_PROPERTY_PAYOUT_BRANCH_CODE = "payoutBranchCode";
  private String payoutBranchCode;

  public static final String JSON_PROPERTY_PAYOUT_REFERENCE = "payoutReference";
  private Long payoutReference;

  /**
   * Speed with which payouts for this account are processed. Permitted values: &#x60;STANDARD&#x60;, &#x60;SAME_DAY&#x60;.
   */
  public enum PayoutSpeedEnum {
    INSTANT("INSTANT"),
    
    SAME_DAY("SAME_DAY"),
    
    STANDARD("STANDARD");

    private String value;

    PayoutSpeedEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayoutSpeedEnum fromValue(String value) {
      for (PayoutSpeedEnum b : PayoutSpeedEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYOUT_SPEED = "payoutSpeed";
  private PayoutSpeedEnum payoutSpeed;

  public static final String JSON_PROPERTY_STATUS = "status";
  private OperationStatus status;

  public AccountHolderPayoutNotificationContent() { 
  }

  public AccountHolderPayoutNotificationContent accountCode(String accountCode) {
    this.accountCode = accountCode;
    return this;
  }

   /**
   * The code of the account from which the payout was made.
   * @return accountCode
  **/
  @ApiModelProperty(value = "The code of the account from which the payout was made.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountCode() {
    return accountCode;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountCode(String accountCode) {
    this.accountCode = accountCode;
  }


  public AccountHolderPayoutNotificationContent accountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
    return this;
  }

   /**
   * The code of the Account Holder to which the payout was made.
   * @return accountHolderCode
  **/
  @ApiModelProperty(value = "The code of the Account Holder to which the payout was made.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountHolderCode() {
    return accountHolderCode;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
  }


  public AccountHolderPayoutNotificationContent amounts(List<Amount> amounts) {
    this.amounts = amounts;
    return this;
  }

  public AccountHolderPayoutNotificationContent addAmountsItem(Amount amountsItem) {
    if (this.amounts == null) {
      this.amounts = new ArrayList<>();
    }
    this.amounts.add(amountsItem);
    return this;
  }

   /**
   * The payout amounts (per currency).
   * @return amounts
  **/
  @ApiModelProperty(value = "The payout amounts (per currency).")
  @JsonProperty(JSON_PROPERTY_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Amount> getAmounts() {
    return amounts;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmounts(List<Amount> amounts) {
    this.amounts = amounts;
  }


  public AccountHolderPayoutNotificationContent bankAccountDetail(BankAccountDetail bankAccountDetail) {
    this.bankAccountDetail = bankAccountDetail;
    return this;
  }

   /**
   * Get bankAccountDetail
   * @return bankAccountDetail
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_DETAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BankAccountDetail getBankAccountDetail() {
    return bankAccountDetail;
  }


  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_DETAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccountDetail(BankAccountDetail bankAccountDetail) {
    this.bankAccountDetail = bankAccountDetail;
  }


  public AccountHolderPayoutNotificationContent description(String description) {
    this.description = description;
    return this;
  }

   /**
   * A description of the payout.
   * @return description
  **/
  @ApiModelProperty(value = "A description of the payout.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public AccountHolderPayoutNotificationContent estimatedArrivalDate(LocalDate estimatedArrivalDate) {
    this.estimatedArrivalDate = estimatedArrivalDate;
    return this;
  }

   /**
   * Get estimatedArrivalDate
   * @return estimatedArrivalDate
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ESTIMATED_ARRIVAL_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEstimatedArrivalDate() {
    return estimatedArrivalDate;
  }


  @JsonProperty(JSON_PROPERTY_ESTIMATED_ARRIVAL_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEstimatedArrivalDate(LocalDate estimatedArrivalDate) {
    this.estimatedArrivalDate = estimatedArrivalDate;
  }


  public AccountHolderPayoutNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
    return this;
  }

  public AccountHolderPayoutNotificationContent addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
    if (this.invalidFields == null) {
      this.invalidFields = new ArrayList<>();
    }
    this.invalidFields.add(invalidFieldsItem);
    return this;
  }

   /**
   * Invalid fields list.
   * @return invalidFields
  **/
  @ApiModelProperty(value = "Invalid fields list.")
  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ErrorFieldType> getInvalidFields() {
    return invalidFields;
  }


  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
  }


  public AccountHolderPayoutNotificationContent merchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
    return this;
  }

   /**
   * The merchant reference.
   * @return merchantReference
  **/
  @ApiModelProperty(value = "The merchant reference.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantReference() {
    return merchantReference;
  }


  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }


  public AccountHolderPayoutNotificationContent originalPspReference(String originalPspReference) {
    this.originalPspReference = originalPspReference;
    return this;
  }

   /**
   * The PSP reference of the original payout.
   * @return originalPspReference
  **/
  @ApiModelProperty(value = "The PSP reference of the original payout.")
  @JsonProperty(JSON_PROPERTY_ORIGINAL_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOriginalPspReference() {
    return originalPspReference;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalPspReference(String originalPspReference) {
    this.originalPspReference = originalPspReference;
  }


  public AccountHolderPayoutNotificationContent payoutAccountCountry(String payoutAccountCountry) {
    this.payoutAccountCountry = payoutAccountCountry;
    return this;
  }

   /**
   * The country code of the bank from which the payout was initiated.
   * @return payoutAccountCountry
  **/
  @ApiModelProperty(value = "The country code of the bank from which the payout was initiated.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_ACCOUNT_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutAccountCountry() {
    return payoutAccountCountry;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_ACCOUNT_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutAccountCountry(String payoutAccountCountry) {
    this.payoutAccountCountry = payoutAccountCountry;
  }


  public AccountHolderPayoutNotificationContent payoutAccountNumber(String payoutAccountNumber) {
    this.payoutAccountNumber = payoutAccountNumber;
    return this;
  }

   /**
   * The account number of the bank from which the payout was initiated.
   * @return payoutAccountNumber
  **/
  @ApiModelProperty(value = "The account number of the bank from which the payout was initiated.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutAccountNumber() {
    return payoutAccountNumber;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutAccountNumber(String payoutAccountNumber) {
    this.payoutAccountNumber = payoutAccountNumber;
  }


  public AccountHolderPayoutNotificationContent payoutBalanceAccountId(String payoutBalanceAccountId) {
    this.payoutBalanceAccountId = payoutBalanceAccountId;
    return this;
  }

   /**
   * The balance account id to which payment was made
   * @return payoutBalanceAccountId
  **/
  @ApiModelProperty(value = "The balance account id to which payment was made")
  @JsonProperty(JSON_PROPERTY_PAYOUT_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutBalanceAccountId() {
    return payoutBalanceAccountId;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutBalanceAccountId(String payoutBalanceAccountId) {
    this.payoutBalanceAccountId = payoutBalanceAccountId;
  }


  public AccountHolderPayoutNotificationContent payoutBankName(String payoutBankName) {
    this.payoutBankName = payoutBankName;
    return this;
  }

   /**
   * The name of the bank the payout from which the payout was initiated.
   * @return payoutBankName
  **/
  @ApiModelProperty(value = "The name of the bank the payout from which the payout was initiated.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_BANK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutBankName() {
    return payoutBankName;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_BANK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutBankName(String payoutBankName) {
    this.payoutBankName = payoutBankName;
  }


  public AccountHolderPayoutNotificationContent payoutBranchCode(String payoutBranchCode) {
    this.payoutBranchCode = payoutBranchCode;
    return this;
  }

   /**
   * The branch code of the bank from which the payout was initiated.
   * @return payoutBranchCode
  **/
  @ApiModelProperty(value = "The branch code of the bank from which the payout was initiated.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_BRANCH_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutBranchCode() {
    return payoutBranchCode;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_BRANCH_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutBranchCode(String payoutBranchCode) {
    this.payoutBranchCode = payoutBranchCode;
  }


  public AccountHolderPayoutNotificationContent payoutReference(Long payoutReference) {
    this.payoutReference = payoutReference;
    return this;
  }

   /**
   * The unique payout identifier.
   * @return payoutReference
  **/
  @ApiModelProperty(value = "The unique payout identifier.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPayoutReference() {
    return payoutReference;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutReference(Long payoutReference) {
    this.payoutReference = payoutReference;
  }


  public AccountHolderPayoutNotificationContent payoutSpeed(PayoutSpeedEnum payoutSpeed) {
    this.payoutSpeed = payoutSpeed;
    return this;
  }

   /**
   * Speed with which payouts for this account are processed. Permitted values: &#x60;STANDARD&#x60;, &#x60;SAME_DAY&#x60;.
   * @return payoutSpeed
  **/
  @ApiModelProperty(value = "Speed with which payouts for this account are processed. Permitted values: `STANDARD`, `SAME_DAY`.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_SPEED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayoutSpeedEnum getPayoutSpeed() {
    return payoutSpeed;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_SPEED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutSpeed(PayoutSpeedEnum payoutSpeed) {
    this.payoutSpeed = payoutSpeed;
  }


  public AccountHolderPayoutNotificationContent status(OperationStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationStatus getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(OperationStatus status) {
    this.status = status;
  }


  /**
   * Return true if this AccountHolderPayoutNotificationContent object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountHolderPayoutNotificationContent accountHolderPayoutNotificationContent = (AccountHolderPayoutNotificationContent) o;
    return Objects.equals(this.accountCode, accountHolderPayoutNotificationContent.accountCode) &&
        Objects.equals(this.accountHolderCode, accountHolderPayoutNotificationContent.accountHolderCode) &&
        Objects.equals(this.amounts, accountHolderPayoutNotificationContent.amounts) &&
        Objects.equals(this.bankAccountDetail, accountHolderPayoutNotificationContent.bankAccountDetail) &&
        Objects.equals(this.description, accountHolderPayoutNotificationContent.description) &&
        Objects.equals(this.estimatedArrivalDate, accountHolderPayoutNotificationContent.estimatedArrivalDate) &&
        Objects.equals(this.invalidFields, accountHolderPayoutNotificationContent.invalidFields) &&
        Objects.equals(this.merchantReference, accountHolderPayoutNotificationContent.merchantReference) &&
        Objects.equals(this.originalPspReference, accountHolderPayoutNotificationContent.originalPspReference) &&
        Objects.equals(this.payoutAccountCountry, accountHolderPayoutNotificationContent.payoutAccountCountry) &&
        Objects.equals(this.payoutAccountNumber, accountHolderPayoutNotificationContent.payoutAccountNumber) &&
        Objects.equals(this.payoutBalanceAccountId, accountHolderPayoutNotificationContent.payoutBalanceAccountId) &&
        Objects.equals(this.payoutBankName, accountHolderPayoutNotificationContent.payoutBankName) &&
        Objects.equals(this.payoutBranchCode, accountHolderPayoutNotificationContent.payoutBranchCode) &&
        Objects.equals(this.payoutReference, accountHolderPayoutNotificationContent.payoutReference) &&
        Objects.equals(this.payoutSpeed, accountHolderPayoutNotificationContent.payoutSpeed) &&
        Objects.equals(this.status, accountHolderPayoutNotificationContent.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountCode, accountHolderCode, amounts, bankAccountDetail, description, estimatedArrivalDate, invalidFields, merchantReference, originalPspReference, payoutAccountCountry, payoutAccountNumber, payoutBalanceAccountId, payoutBankName, payoutBranchCode, payoutReference, payoutSpeed, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountHolderPayoutNotificationContent {\n");
    sb.append("    accountCode: ").append(toIndentedString(accountCode)).append("\n");
    sb.append("    accountHolderCode: ").append(toIndentedString(accountHolderCode)).append("\n");
    sb.append("    amounts: ").append(toIndentedString(amounts)).append("\n");
    sb.append("    bankAccountDetail: ").append(toIndentedString(bankAccountDetail)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    estimatedArrivalDate: ").append(toIndentedString(estimatedArrivalDate)).append("\n");
    sb.append("    invalidFields: ").append(toIndentedString(invalidFields)).append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    originalPspReference: ").append(toIndentedString(originalPspReference)).append("\n");
    sb.append("    payoutAccountCountry: ").append(toIndentedString(payoutAccountCountry)).append("\n");
    sb.append("    payoutAccountNumber: ").append(toIndentedString(payoutAccountNumber)).append("\n");
    sb.append("    payoutBalanceAccountId: ").append(toIndentedString(payoutBalanceAccountId)).append("\n");
    sb.append("    payoutBankName: ").append(toIndentedString(payoutBankName)).append("\n");
    sb.append("    payoutBranchCode: ").append(toIndentedString(payoutBranchCode)).append("\n");
    sb.append("    payoutReference: ").append(toIndentedString(payoutReference)).append("\n");
    sb.append("    payoutSpeed: ").append(toIndentedString(payoutSpeed)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AccountHolderPayoutNotificationContent given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AccountHolderPayoutNotificationContent
   * @throws JsonProcessingException if the JSON string is invalid with respect to AccountHolderPayoutNotificationContent
   */
  public static AccountHolderPayoutNotificationContent fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AccountHolderPayoutNotificationContent.class);
  }
/**
  * Convert an instance of AccountHolderPayoutNotificationContent to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

