/*
 * Adyen Payout API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * FraudCheckResult
 */
@JsonPropertyOrder({
  FraudCheckResult.JSON_PROPERTY_ACCOUNT_SCORE,
  FraudCheckResult.JSON_PROPERTY_CHECK_ID,
  FraudCheckResult.JSON_PROPERTY_NAME
})

public class FraudCheckResult {
  public static final String JSON_PROPERTY_ACCOUNT_SCORE = "accountScore";
  private Integer accountScore;

  public static final String JSON_PROPERTY_CHECK_ID = "checkId";
  private Integer checkId;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public FraudCheckResult() { 
  }

  /**
   * The fraud score generated by the risk check.
   *
   * @param accountScore
   * @return the current {@code FraudCheckResult} instance, allowing for method chaining
   */
  public FraudCheckResult accountScore(Integer accountScore) {
    this.accountScore = accountScore;
    return this;
  }

  /**
   * The fraud score generated by the risk check.
   * @return accountScore
   */
  @ApiModelProperty(required = true, value = "The fraud score generated by the risk check.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getAccountScore() {
    return accountScore;
  }

  /**
   * The fraud score generated by the risk check.
   *
   * @param accountScore
   */ 
  @JsonProperty(JSON_PROPERTY_ACCOUNT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountScore(Integer accountScore) {
    this.accountScore = accountScore;
  }

  /**
   * The ID of the risk check.
   *
   * @param checkId
   * @return the current {@code FraudCheckResult} instance, allowing for method chaining
   */
  public FraudCheckResult checkId(Integer checkId) {
    this.checkId = checkId;
    return this;
  }

  /**
   * The ID of the risk check.
   * @return checkId
   */
  @ApiModelProperty(required = true, value = "The ID of the risk check.")
  @JsonProperty(JSON_PROPERTY_CHECK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getCheckId() {
    return checkId;
  }

  /**
   * The ID of the risk check.
   *
   * @param checkId
   */ 
  @JsonProperty(JSON_PROPERTY_CHECK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckId(Integer checkId) {
    this.checkId = checkId;
  }

  /**
   * The name of the risk check.
   *
   * @param name
   * @return the current {@code FraudCheckResult} instance, allowing for method chaining
   */
  public FraudCheckResult name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the risk check.
   * @return name
   */
  @ApiModelProperty(required = true, value = "The name of the risk check.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  /**
   * The name of the risk check.
   *
   * @param name
   */ 
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Return true if this FraudCheckResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FraudCheckResult fraudCheckResult = (FraudCheckResult) o;
    return Objects.equals(this.accountScore, fraudCheckResult.accountScore) &&
        Objects.equals(this.checkId, fraudCheckResult.checkId) &&
        Objects.equals(this.name, fraudCheckResult.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountScore, checkId, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FraudCheckResult {\n");
    sb.append("    accountScore: ").append(toIndentedString(accountScore)).append("\n");
    sb.append("    checkId: ").append(toIndentedString(checkId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of FraudCheckResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of FraudCheckResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to FraudCheckResult
   */
  public static FraudCheckResult fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, FraudCheckResult.class);
  }
/**
  * Convert an instance of FraudCheckResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
