/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.ApplePayInfo;
import com.adyen.model.management.PaymentMethod;
import com.adyen.model.management.PaymentMethodResponse;
import com.adyen.model.management.PaymentMethodSetupInfo;
import com.adyen.model.management.RestServiceError;
import com.adyen.model.management.UpdatePaymentMethodInfo;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PaymentMethodsMerchantLevelApi extends Service {

    public static final String API_VERSION = "3";

    protected String baseURL;

    /**
    * Payment methods - merchant level constructor in {@link com.adyen.service.management package}.
    * @param client {@link Client } (required)
    */
    public PaymentMethodsMerchantLevelApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://management-test.adyen.com/v3");
    }

    /**
    * Payment methods - merchant level constructor in {@link com.adyen.service.management package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public PaymentMethodsMerchantLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Add an Apple Pay domain
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param paymentMethodId {@link String } The unique identifier of the payment method. (required)
    * @param applePayInfo {@link ApplePayInfo }  (required)
    * @throws ApiException if fails to make API call
    */
    public void addApplePayDomain(String merchantId, String paymentMethodId, ApplePayInfo applePayInfo) throws ApiException, IOException {
        addApplePayDomain(merchantId, paymentMethodId, applePayInfo, null);
    }

    /**
    * Add an Apple Pay domain
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param paymentMethodId {@link String } The unique identifier of the payment method. (required)
    * @param applePayInfo {@link ApplePayInfo }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @throws ApiException if fails to make API call
    */
    public void addApplePayDomain(String merchantId, String paymentMethodId, ApplePayInfo applePayInfo, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (paymentMethodId == null) {
            throw new IllegalArgumentException("Please provide the paymentMethodId path parameter");
        }
        pathParams.put("paymentMethodId", paymentMethodId);

        String requestBody = applePayInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}/addApplePayDomains", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
    }

    /**
    * Get all payment methods
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @return {@link PaymentMethodResponse }
    * @throws ApiException if fails to make API call
    */
    public PaymentMethodResponse getAllPaymentMethods(String merchantId) throws ApiException, IOException {
        return getAllPaymentMethods(merchantId, null,  null,  null,  null,  null);
    }

    /**
    * Get all payment methods
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param storeId {@link String } Query: The unique identifier of the store for which to return the payment methods. (optional)
    * @param businessLineId {@link String } Query: The unique identifier of the Business Line for which to return the payment methods. (optional)
    * @param pageSize {@link Integer } Query: The number of items to have on a page, maximum 100. The default is 10 items on a page. (optional)
    * @param pageNumber {@link Integer } Query: The number of the page to fetch. (optional)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentMethodResponse }
    * @throws ApiException if fails to make API call
    */
    public PaymentMethodResponse getAllPaymentMethods(String merchantId, String storeId, String businessLineId, Integer pageSize, Integer pageNumber, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (storeId != null) {
        queryParams.put("storeId", storeId);
        }
        if (businessLineId != null) {
        queryParams.put("businessLineId", businessLineId);
        }
        if (pageSize != null) {
        queryParams.put("pageSize", pageSize.toString());
        }
        if (pageNumber != null) {
        queryParams.put("pageNumber", pageNumber.toString());
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaymentMethodResponse.fromJson(jsonResult);
    }

    /**
    * Get Apple Pay domains
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param paymentMethodId {@link String } The unique identifier of the payment method. (required)
    * @return {@link ApplePayInfo }
    * @throws ApiException if fails to make API call
    */
    public ApplePayInfo getApplePayDomains(String merchantId, String paymentMethodId) throws ApiException, IOException {
        return getApplePayDomains(merchantId, paymentMethodId, null);
    }

    /**
    * Get Apple Pay domains
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param paymentMethodId {@link String } The unique identifier of the payment method. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ApplePayInfo }
    * @throws ApiException if fails to make API call
    */
    public ApplePayInfo getApplePayDomains(String merchantId, String paymentMethodId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (paymentMethodId == null) {
            throw new IllegalArgumentException("Please provide the paymentMethodId path parameter");
        }
        pathParams.put("paymentMethodId", paymentMethodId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}/getApplePayDomains", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return ApplePayInfo.fromJson(jsonResult);
    }

    /**
    * Get payment method details
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param paymentMethodId {@link String } The unique identifier of the payment method. (required)
    * @return {@link PaymentMethod }
    * @throws ApiException if fails to make API call
    */
    public PaymentMethod getPaymentMethodDetails(String merchantId, String paymentMethodId) throws ApiException, IOException {
        return getPaymentMethodDetails(merchantId, paymentMethodId, null);
    }

    /**
    * Get payment method details
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param paymentMethodId {@link String } The unique identifier of the payment method. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentMethod }
    * @throws ApiException if fails to make API call
    */
    public PaymentMethod getPaymentMethodDetails(String merchantId, String paymentMethodId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (paymentMethodId == null) {
            throw new IllegalArgumentException("Please provide the paymentMethodId path parameter");
        }
        pathParams.put("paymentMethodId", paymentMethodId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PaymentMethod.fromJson(jsonResult);
    }

    /**
    * Request a payment method
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param paymentMethodSetupInfo {@link PaymentMethodSetupInfo }  (required)
    * @return {@link PaymentMethod }
    * @throws ApiException if fails to make API call
    */
    public PaymentMethod requestPaymentMethod(String merchantId, PaymentMethodSetupInfo paymentMethodSetupInfo) throws ApiException, IOException {
        return requestPaymentMethod(merchantId, paymentMethodSetupInfo, null);
    }

    /**
    * Request a payment method
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param paymentMethodSetupInfo {@link PaymentMethodSetupInfo }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentMethod }
    * @throws ApiException if fails to make API call
    */
    public PaymentMethod requestPaymentMethod(String merchantId, PaymentMethodSetupInfo paymentMethodSetupInfo, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);

        String requestBody = paymentMethodSetupInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return PaymentMethod.fromJson(jsonResult);
    }

    /**
    * Update a payment method
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param paymentMethodId {@link String } The unique identifier of the payment method. (required)
    * @param updatePaymentMethodInfo {@link UpdatePaymentMethodInfo }  (required)
    * @return {@link PaymentMethod }
    * @throws ApiException if fails to make API call
    */
    public PaymentMethod updatePaymentMethod(String merchantId, String paymentMethodId, UpdatePaymentMethodInfo updatePaymentMethodInfo) throws ApiException, IOException {
        return updatePaymentMethod(merchantId, paymentMethodId, updatePaymentMethodInfo, null);
    }

    /**
    * Update a payment method
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param paymentMethodId {@link String } The unique identifier of the payment method. (required)
    * @param updatePaymentMethodInfo {@link UpdatePaymentMethodInfo }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentMethod }
    * @throws ApiException if fails to make API call
    */
    public PaymentMethod updatePaymentMethod(String merchantId, String paymentMethodId, UpdatePaymentMethodInfo updatePaymentMethodInfo, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (paymentMethodId == null) {
            throw new IllegalArgumentException("Please provide the paymentMethodId path parameter");
        }
        pathParams.put("paymentMethodId", paymentMethodId);

        String requestBody = updatePaymentMethodInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return PaymentMethod.fromJson(jsonResult);
    }
}
