/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"allowed", "allowedLevel", "enabled", "id", "requested", "requestedLevel", "verificationStatus"})
public class AccountSupportingEntityCapability {
    public static final String JSON_PROPERTY_ALLOWED = "allowed";
    private Boolean allowed;
    public static final String JSON_PROPERTY_ALLOWED_LEVEL = "allowedLevel";
    private AllowedLevelEnum allowedLevel;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_REQUESTED = "requested";
    private Boolean requested;
    public static final String JSON_PROPERTY_REQUESTED_LEVEL = "requestedLevel";
    private RequestedLevelEnum requestedLevel;
    public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
    private VerificationStatusEnum verificationStatus;

    public AccountSupportingEntityCapability allowed(Boolean allowed) {
        this.allowed = allowed;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the supporting entity capability is allowed. Adyen sets this to **true** if the verification is successful and the account holder is permitted to use the capability.")
    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowed() {
        return this.allowed;
    }

    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public AccountSupportingEntityCapability allowedLevel(AllowedLevelEnum allowedLevel) {
        this.allowedLevel = allowedLevel;
        return this;
    }

    @ApiModelProperty(value="The capability level that is allowed for the account holder.  Possible values: **notApplicable**, **low**, **medium**, **high**.")
    @JsonProperty(value="allowedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AllowedLevelEnum getAllowedLevel() {
        return this.allowedLevel;
    }

    @JsonProperty(value="allowedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedLevel(AllowedLevelEnum allowedLevel) {
        this.allowedLevel = allowedLevel;
    }

    public AccountSupportingEntityCapability enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the capability is enabled. If **false**, the capability is temporarily disabled for the account holder.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AccountSupportingEntityCapability id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the supporting entity.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public AccountSupportingEntityCapability requested(Boolean requested) {
        this.requested = requested;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the capability is requested. To check whether the account holder is permitted to use the capability, refer to the `allowed` field.")
    @JsonProperty(value="requested")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequested() {
        return this.requested;
    }

    @JsonProperty(value="requested")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequested(Boolean requested) {
        this.requested = requested;
    }

    public AccountSupportingEntityCapability requestedLevel(RequestedLevelEnum requestedLevel) {
        this.requestedLevel = requestedLevel;
        return this;
    }

    @ApiModelProperty(value="The requested level of the capability. Some capabilities, such as those used in [card issuing](https://docs.adyen.com/issuing/add-capabilities#capability-levels), have different levels. Levels increase the capability, but also require additional checks and increased monitoring.  Possible values: **notApplicable**, **low**, **medium**, **high**.")
    @JsonProperty(value="requestedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RequestedLevelEnum getRequestedLevel() {
        return this.requestedLevel;
    }

    @JsonProperty(value="requestedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestedLevel(RequestedLevelEnum requestedLevel) {
        this.requestedLevel = requestedLevel;
    }

    public AccountSupportingEntityCapability verificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @ApiModelProperty(value="The status of the verification checks for the supporting entity capability.  Possible values:  * **pending**: Adyen is running the verification.  * **invalid**: The verification failed. Check if the `errors` array contains more information.  * **valid**: The verification has been successfully completed.  * **rejected**: Adyen has verified the information, but found reasons to not allow the capability. ")
    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VerificationStatusEnum getVerificationStatus() {
        return this.verificationStatus;
    }

    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountSupportingEntityCapability accountSupportingEntityCapability = (AccountSupportingEntityCapability)o;
        return Objects.equals(this.allowed, accountSupportingEntityCapability.allowed) && Objects.equals((Object)this.allowedLevel, (Object)accountSupportingEntityCapability.allowedLevel) && Objects.equals(this.enabled, accountSupportingEntityCapability.enabled) && Objects.equals(this.id, accountSupportingEntityCapability.id) && Objects.equals(this.requested, accountSupportingEntityCapability.requested) && Objects.equals((Object)this.requestedLevel, (Object)accountSupportingEntityCapability.requestedLevel) && Objects.equals((Object)this.verificationStatus, (Object)accountSupportingEntityCapability.verificationStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowed, this.allowedLevel, this.enabled, this.id, this.requested, this.requestedLevel, this.verificationStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountSupportingEntityCapability {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    allowedLevel: ").append(this.toIndentedString((Object)this.allowedLevel)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    requested: ").append(this.toIndentedString(this.requested)).append("\n");
        sb.append("    requestedLevel: ").append(this.toIndentedString((Object)this.requestedLevel)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountSupportingEntityCapability fromJson(String jsonString) throws JsonProcessingException {
        return (AccountSupportingEntityCapability)JSON.getMapper().readValue(jsonString, AccountSupportingEntityCapability.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum VerificationStatusEnum {
        INVALID("invalid"),
        PENDING("pending"),
        REJECTED("rejected"),
        VALID("valid");

        private String value;

        private VerificationStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VerificationStatusEnum fromValue(String value) {
            for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RequestedLevelEnum {
        HIGH("high"),
        LOW("low"),
        MEDIUM("medium"),
        NOTAPPLICABLE("notApplicable");

        private String value;

        private RequestedLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestedLevelEnum fromValue(String value) {
            for (RequestedLevelEnum b : RequestedLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AllowedLevelEnum {
        HIGH("high"),
        LOW("low"),
        MEDIUM("medium"),
        NOTAPPLICABLE("notApplicable");

        private String value;

        private AllowedLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AllowedLevelEnum fromValue(String value) {
            for (AllowedLevelEnum b : AllowedLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

